/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.data.GlassFishContainer;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.Jar;
import org.glassfish.tools.ide.utils.JavaUtils;
import org.glassfish.tools.ide.utils.OsUtils;

public class ServerUtils {
    public static final String AS_JAVA_ENV = "AS_JAVA";
    public static final String GF_JAVA_ROOT_PROPERTY = "com.sun.aas.javaRoot";
    public static final GlassFishFilter GF_HOME_DIR_FILTER = new GlassFishFilter();
    public static final String GF_MODULES_DIR_NAME = "modules";
    public static final String GFV3_LIB_DIR_NAME = "lib";
    public static final String GFV3_VERSION_MATCHER = "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GFV3_JAR_MATCHER = "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    public static final String GF_COMMON_UTIL_JAR = "common-util.jar";
    public static final String GF_JERSEY_2_COMMON_JAR = "jersey-common.jar";
    public static final String GF_JERSEY_1_CORE_JAR = "jersey-core.jar";
    private static String VERSION_CLASS = "com.sun.appserv.server.util.Version";
    private static String FULL_VERSION_PATTERN = "[0-9]+(\\.[0-9]+){1,3}";
    private static String FULL_VERSION_METHOD = "getFullVersion";
    private static String AUTH_BASIC_FIELD_SEPARATPR = ":";
    public static String GF_DOMAIN_ARG = "--domain";
    public static String GF_DOMAIN_DIR_ARG = "--domaindir";
    public static final String GF_SERVICE_NOT_YET_READY_MSG = "V3 cannot process this command at this time, please wait";
    public static final String MANIFEST_EOL = "%%%EOL%%%";
    public static final String MANIFEST_RESOURCES_SEPARATOR = "[,;]";
    public static final String MANIFEST_COMPONENTS_SEPARATOR = ";";
    private static final String MANIFEST_COMPONENT_FULL_REGEX = " *([^ ]+) +< *([^ ,]+) *((?:, *[^ ,]+ *)*)> *";
    private static final String MANIFEST_COMPONENT_COMP_REGEX = ", *([^ ,]+) *";
    private static final Pattern MANIFEST_COMPONENT_FULL_PATTERN = Pattern.compile(" *([^ ]+) +< *([^ ,]+) *((?:, *[^ ,]+ *)*)> *", 2);
    private static final Pattern MANIFEST_COMPONENT_COMP_PATTERN = Pattern.compile(", *([^ ,]+) *", 2);

    public static File getJarName(String serverHome, String pattern) {
        return ServerUtils.getJarName(serverHome, pattern, GF_MODULES_DIR_NAME);
    }

    public static File getJarName(String serverHome, String pattern, String dir) {
        File dirFile = new File(serverHome + File.separatorChar + dir);
        return ServerUtils.getFileFromPattern(pattern, dirFile);
    }

    public static File getFileFromPattern(String pattern, File dir) {
        assert (pattern != null) : "Search pattern should not be null";
        assert (dir != null) : "Search directory tree root should not be null";
        if (null == pattern) {
            Logger.log(Level.WARNING, "Search pattern is null.");
            return null;
        }
        if (null == dir) {
            Logger.log(Level.WARNING, "Search directory tree root is null.");
            return null;
        }
        int subindex = pattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = pattern.substring(0, subindex);
            pattern = pattern.substring(subindex + 1);
            dir = new File(dir, subdir);
        }
        if (dir.canRead() && dir.isDirectory()) {
            String expressPattern = pattern.replace(GFV3_VERSION_MATCHER, ".jar");
            File candidate = new File(dir, expressPattern);
            if (!"".equals(expressPattern) && candidate.exists()) {
                return candidate;
            }
            File[] candidates = dir.listFiles(new VersionFilter(pattern));
            if (candidates != null && candidates.length > 0) {
                return candidates[0];
            }
        }
        return null;
    }

    public static void addPathElement(StringBuilder rootPath, String next) {
        int rootPathLength = rootPath.length();
        if (rootPathLength > 0 && rootPath.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != rootPathLength) {
            rootPath.append(File.separator);
        }
        rootPath.append(next);
    }

    public static File getCommonUtilJarInModules(String serverHome) {
        StringBuilder commonUtilJarPath = new StringBuilder(serverHome.length() + GF_MODULES_DIR_NAME.length() + GF_COMMON_UTIL_JAR.length() + 2 * OsUtils.FILE_SEPARATOR_LENGTH);
        commonUtilJarPath.append(serverHome);
        ServerUtils.addPathElement(commonUtilJarPath, GF_MODULES_DIR_NAME);
        ServerUtils.addPathElement(commonUtilJarPath, GF_COMMON_UTIL_JAR);
        return new File(commonUtilJarPath.toString());
    }

    public static File getJerseyCommonJarInModules(String serverHome, String jarName) {
        StringBuilder commonUtilJarPath = new StringBuilder(serverHome.length() + GF_MODULES_DIR_NAME.length() + jarName.length() + 2 * OsUtils.FILE_SEPARATOR_LENGTH);
        commonUtilJarPath.append(serverHome);
        ServerUtils.addPathElement(commonUtilJarPath, GF_MODULES_DIR_NAME);
        ServerUtils.addPathElement(commonUtilJarPath, jarName);
        return new File(commonUtilJarPath.toString());
    }

    public static File getJerseyCommonJarInModules(String serverHome) {
        File jerseyCommon = ServerUtils.getJerseyCommonJarInModules(serverHome, GF_JERSEY_2_COMMON_JAR);
        if (jerseyCommon.isFile() && jerseyCommon.canRead()) {
            return jerseyCommon;
        }
        jerseyCommon = ServerUtils.getJerseyCommonJarInModules(serverHome, GF_JERSEY_1_CORE_JAR);
        if (jerseyCommon.isFile() && jerseyCommon.canRead()) {
            return jerseyCommon;
        }
        return null;
    }

    public static String getJerseyVersion(String serverHome) {
        File jerseyFile = ServerUtils.getJerseyCommonJarInModules(serverHome);
        if (jerseyFile != null) {
            Jar jerseyJar = new Jar(jerseyFile);
            String version = jerseyJar.getBundleVersion();
            jerseyJar.close();
            return version;
        }
        return null;
    }

    public static String getVersionString(String fullVersionString) {
        Pattern p;
        Matcher m;
        if (fullVersionString != null && (m = (p = Pattern.compile(FULL_VERSION_PATTERN)).matcher(fullVersionString)).find()) {
            return fullVersionString.substring(m.start(), m.end());
        }
        return null;
    }

    public static GlassFishVersion getServerVersion(String serverHome) {
        GlassFishVersion version = null;
        File commonUtilJar = ServerUtils.getCommonUtilJarInModules(serverHome);
        if (commonUtilJar.canRead()) {
            try {
                URLClassLoader cl = new URLClassLoader(new URL[]{commonUtilJar.toURI().toURL()});
                Class<?> c = cl.loadClass(VERSION_CLASS);
                try {
                    Method mGetFullVersion = c.getMethod(FULL_VERSION_METHOD, new Class[0]);
                    String versionString = ServerUtils.getVersionString((String)mGetFullVersion.invoke(c, new Object[0]));
                    version = GlassFishVersion.toValue(versionString);
                }
                catch (IllegalAccessException iae) {
                    Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", iae);
                }
                catch (IllegalArgumentException iae) {
                    Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", iae);
                }
                catch (InvocationTargetException ite) {
                    Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", ite);
                }
                catch (NoSuchMethodException nme) {
                    Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", nme);
                }
                catch (SecurityException se) {
                    Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", se);
                }
            }
            catch (MalformedURLException mue) {
                Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", mue);
            }
            catch (ClassNotFoundException cnfe) {
                Logger.log(Level.WARNING, "Cannot retrieve Glassfish version: " + commonUtilJar.getAbsolutePath() + ": ", cnfe);
            }
        }
        return version;
    }

    public static String manifestDecode(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(MANIFEST_EOL, "\n");
    }

    public static String basicAuthCredentials(String user, String password) {
        StringBuilder sb = new StringBuilder(user.length() + AUTH_BASIC_FIELD_SEPARATPR.length() + password.length());
        sb.append(user);
        sb.append(AUTH_BASIC_FIELD_SEPARATPR);
        sb.append(password);
        return DatatypeConverter.printBase64Binary((byte[])sb.toString().getBytes());
    }

    public static boolean isRunning(GlassFishServer server) {
        return ServerUtils.isRunning(server.getHost(), server.getPort());
    }

    private static boolean isRunning(String host, int port) {
        if (null == host) {
            return false;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            Socket socket = new Socket();
            socket.connect(isa, 100);
            socket.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static String cmdLineArgument(String name, String value) {
        StringBuilder sb = new StringBuilder(name.length() + " ".length() + value.length());
        sb.append(name);
        sb.append(" ");
        sb.append(value);
        return sb.toString();
    }

    public static void addComponentToMap(Map<String, List<String>> map, String component) {
        List<String> componentList;
        String componentName;
        Logger.log(Level.FINER, "Processing component \"{0}\"", new Object[]{component});
        Matcher fullMatecher = MANIFEST_COMPONENT_FULL_PATTERN.matcher(component);
        if (fullMatecher.matches()) {
            String containerName;
            componentName = fullMatecher.group(1);
            GlassFishContainer container = GlassFishContainer.toValue(fullMatecher.group(2));
            String moreContainers = fullMatecher.group(3);
            if (moreContainers != null && moreContainers.length() > 0) {
                Matcher compMatcher = MANIFEST_COMPONENT_COMP_PATTERN.matcher(moreContainers);
                while (compMatcher.find()) {
                    GlassFishContainer nextContainer = GlassFishContainer.toValue(compMatcher.group(1));
                    if (nextContainer != null && container != null && nextContainer.ordinal() < container.ordinal()) {
                        container = nextContainer;
                        continue;
                    }
                    if (nextContainer != null) continue;
                    Logger.log(Level.WARNING, "Error processing component \"{0}\"", new Object[]{component});
                }
            }
            if ((componentList = map.get(containerName = container != null ? container.toString() : "null")) == null) {
                componentList = new ArrayList<String>();
                map.put(containerName, componentList);
            }
        } else {
            throw new CommandException("Invalid component item");
        }
        componentList.add(componentName);
    }

    public static String javaRootProperty(String javaHome) {
        return JavaUtils.systemProperty(GF_JAVA_ROOT_PROPERTY, javaHome);
    }

    public static boolean notYetReadyMsg(String msg) {
        if (msg == null) {
            return false;
        }
        return GF_SERVICE_NOT_YET_READY_MSG.equals(msg);
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    public static class GlassFishFilter
    implements FileFilter {
        @Override
        public boolean accept(File path) {
            if (path.isDirectory() && path.canRead()) {
                File commonUtilJar = ServerUtils.getCommonUtilJarInModules(path.getAbsolutePath());
                return commonUtilJar.isFile() && commonUtilJar.canRead();
            }
            return false;
        }
    }
}

