/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.OsUtils;

public class JavaUtils {
    private static final String JAVA_BIN_DIR = "bin";
    private static final String JAVA_VM_EXE = "java";
    private static final String VM_VERSION_OPT = "-version";
    private static final String VM_SYS_PROP_OPT = "-D";
    private static final char VM_SYS_PROP_QUOTE = '\"';
    private static final String VM_SYS_PROP_ASSIGN = "=";
    public static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String VM_VERSION_PATTERN = "[^0-9]*([0-9]+)\\.([0-9]+)(?:\\.([0-9]+)(?:[-_\\.]([0-9]+)){0,1}){0,1}[^0-9]*";
    private static final int VM_MIN_VERSION_TOKENS = 2;

    public static JavaVersion javaVmVersion(File javaVm) {
        Process process;
        ProcessBuilder pb = new ProcessBuilder(javaVm.getAbsolutePath(), VM_VERSION_OPT);
        pb.redirectErrorStream(true);
        try {
            process = pb.start();
        }
        catch (IOException ioe) {
            Logger.log(Level.WARNING, "Caught IOException while executing Java VM.", ioe);
            return null;
        }
        catch (SecurityException se) {
            Logger.log(Level.WARNING, "Caught SecurityException while executing Java VM.", se);
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        int major = 0;
        int minor = 0;
        int revision = 0;
        int patch = 0;
        Pattern pattern = Pattern.compile(VM_VERSION_PATTERN);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int groupCount;
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find() || (groupCount = matcher.groupCount()) < 2) continue;
                major = Integer.parseInt(matcher.group(1));
                minor = Integer.parseInt(matcher.group(2));
                revision = groupCount > 2 ? Integer.parseInt(matcher.group(3)) : 0;
                patch = groupCount > 3 ? Integer.parseInt(matcher.group(4)) : 0;
                break;
            }
        }
        catch (IOException ioe) {
            Logger.log(Level.WARNING, "Caught IOException while reading Java VM output.", ioe);
            return null;
        }
        return new JavaVersion(major, minor, revision, patch);
    }

    public static String javaVmExecutableFullPath(String javaHome) {
        int javaHomeLen = javaHome.length();
        int execSuffixLen = OsUtils.EXEC_SUFFIX.length();
        boolean javaHomeEndsWithPathSep = javaHome.charAt(javaHomeLen - 1) == File.separatorChar;
        boolean isExecSuffix = execSuffixLen > 0;
        StringBuilder javaExecStr = new StringBuilder(javaHomeLen + (javaHomeEndsWithPathSep ? 0 : 1) + JAVA_BIN_DIR.length() + 1 + JAVA_VM_EXE.length() + (isExecSuffix ? execSuffixLen + 1 : 0));
        javaExecStr.append(javaHome);
        if (!javaHomeEndsWithPathSep) {
            javaExecStr.append(File.separatorChar);
        }
        javaExecStr.append(JAVA_BIN_DIR);
        javaExecStr.append(File.separatorChar);
        javaExecStr.append(JAVA_VM_EXE);
        if (isExecSuffix) {
            javaExecStr.append(OsUtils.EXEC_SUFFIX);
        }
        return javaExecStr.toString();
    }

    public static String systemPropertyName(String name) {
        StringBuilder sb = new StringBuilder(2 + VM_SYS_PROP_OPT.length() + name.length());
        sb.append(VM_SYS_PROP_OPT);
        sb.append('\"');
        sb.append(name);
        sb.append('\"');
        return sb.toString();
    }

    public static String systemProperty(String name, String value) {
        StringBuilder sb = new StringBuilder(2 + VM_SYS_PROP_OPT.length() + name.length() + VM_SYS_PROP_ASSIGN.length() + value.length());
        sb.append(VM_SYS_PROP_OPT);
        sb.append('\"');
        sb.append(name);
        sb.append(VM_SYS_PROP_ASSIGN);
        sb.append(value);
        sb.append('\"');
        return sb.toString();
    }

    public static class JavaVersion {
        final int major;
        final int minor;
        final int revision;
        final int patch;

        public JavaVersion(int major, int minor, int revision, int patch) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.patch = patch;
        }

        public int comapreTo(JavaVersion version) {
            return this.major > version.major ? 1 : (this.major < version.major ? -1 : (this.minor > version.minor ? 1 : (this.minor < version.minor ? -1 : (this.revision > version.revision ? 1 : (this.revision < version.revision ? -1 : (this.patch > version.patch ? 1 : (this.patch < version.patch ? -1 : 0)))))));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.major);
            sb.append('.');
            sb.append(this.minor);
            sb.append('.');
            sb.append(this.revision);
            sb.append('_');
            sb.append(this.patch);
            return sb.toString();
        }
    }
}

