/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TreeParser
extends DefaultHandler {
    private static final boolean isFinestLoggable = Logger.isLoggable(Level.FINEST);
    private static final boolean isFinerLoggable = Logger.isLoggable(Level.FINER);
    private final Node root;
    private Node rover;
    private String skipping;
    private int depth;
    private NodeListener childNodeReader;

    public static boolean readXml(File xmlFile, XMLReader ... pathList) throws IllegalStateException {
        boolean result = false;
        InputStream is = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser saxParser = factory.newSAXParser();
            TreeParser handler = new TreeParser(pathList);
            is = new BufferedInputStream(new FileInputStream(xmlFile));
            saxParser.parse(new InputSource(is), (DefaultHandler)handler);
            result = true;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        return result;
    }

    public static boolean readXml(URL xmlFile, XMLReader ... pathList) throws IllegalStateException {
        boolean result = false;
        InputStream is = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser saxParser = factory.newSAXParser();
            TreeParser handler = new TreeParser(pathList);
            is = new BufferedInputStream(xmlFile.openStream());
            saxParser.parse(new InputSource(is), (DefaultHandler)handler);
            result = true;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        return result;
    }

    private TreeParser(XMLReader[] readers) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (XMLReader r : readers) {
            Collections.addAll(pathList, r.getPathsToListen());
        }
        this.root = TreeParser.buildTree(pathList);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.childNodeReader != null) {
            this.childNodeReader.readCData(this.skipping, ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
        if (this.skipping != null) {
            ++this.depth;
            if (this.childNodeReader != null) {
                if (isFinerLoggable) {
                    Logger.log(Level.FINER, "Skip: reading " + qname);
                }
                this.childNodeReader.readChildren(qname, attributes);
            }
            if (isFinestLoggable) {
                Logger.log(Level.FINEST, "Skip: descend, depth is " + this.depth + ", qn is " + qname);
            }
        } else {
            Node child = this.rover.findChild(qname);
            if (child != null) {
                NodeListener reader;
                this.rover = child;
                if (isFinerLoggable) {
                    Logger.log(Level.FINER, "Rover descend to " + this.rover);
                }
                if ((reader = this.rover.getReader()) != null) {
                    if (isFinerLoggable) {
                        Logger.log(Level.FINER, "Rover enter & read node " + qname);
                    }
                    reader.readAttributes(qname, attributes);
                }
            } else {
                this.skipping = qname;
                this.depth = 1;
                this.childNodeReader = this.rover.getReader();
                if (this.childNodeReader != null) {
                    if (isFinerLoggable) {
                        Logger.log(Level.FINER, "Skip: reading " + qname);
                    }
                    this.childNodeReader.readChildren(qname, attributes);
                }
                if (isFinestLoggable) {
                    Logger.log(Level.FINEST, "Skip: start, depth is " + this.depth + ", qn is " + qname);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (this.skipping != null) {
            if (this.childNodeReader != null) {
                this.childNodeReader.endNode(qname);
            }
            if (--this.depth == 0) {
                if (!this.skipping.equals(qname)) {
                    Logger.log(Level.WARNING, "Skip: " + this.skipping + " does not match " + qname + " at depth " + this.depth);
                }
                if (isFinestLoggable) {
                    Logger.log(Level.FINEST, "Skip: ascend, depth is " + this.depth);
                }
                this.skipping = null;
                this.childNodeReader = null;
            } else if (isFinestLoggable) {
                Logger.log(Level.FINEST, "Skip: ascend, depth is " + this.depth);
            }
        } else {
            NodeListener reader = this.rover.getReader();
            if (reader != null) {
                if (isFinerLoggable) {
                    Logger.log(Level.FINER, "Rover exit & read node " + qname);
                }
                reader.endNode(qname);
            }
            this.rover = this.rover.getParent();
            if (isFinerLoggable) {
                Logger.log(Level.FINER, "Rover ascend to " + this.rover);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.rover = this.root;
        this.skipping = null;
        this.depth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private static Node buildTree(List<Path> paths) {
        Node root = null;
        for (Path path : paths) {
            String[] parts = path.getPath().split("/");
            if (parts == null || parts.length == 0) {
                Logger.log(Level.WARNING, "Invalid entry, no parts, skipping: " + path);
                continue;
            }
            if (parts[0] == null) {
                Logger.log(Level.WARNING, "Invalid entry, null root, skipping: " + path);
                continue;
            }
            if (root == null) {
                if (isFinerLoggable) {
                    Logger.log(Level.FINER, "Root node created: " + parts[0]);
                }
                root = new Node(parts[0]);
            }
            Node rover = root;
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i] != null && parts[i].length() > 0) {
                    Node existing = rover.findChild(parts[i]);
                    if (existing != null) {
                        if (isFinerLoggable) {
                            Logger.log(Level.FINER, "Existing node " + parts[i] + " at level " + i);
                        }
                        rover = existing;
                        continue;
                    }
                    if (isFinerLoggable) {
                        Logger.log(Level.FINER, "Adding node " + parts[i] + " at level " + i);
                    }
                    rover = rover.addChild(parts[i]);
                    continue;
                }
                Logger.log(Level.WARNING, "Broken parts found in " + path + " at level " + i);
            }
            if (rover == null) continue;
            rover.setReader(path.getReader());
        }
        return root;
    }

    private static class Node
    implements Comparable<Node> {
        private final String element;
        private final Map<String, Node> children;
        private Node parent;
        private NodeListener reader;

        public Node(String element) {
            this(element, null);
        }

        private Node(String element, Node parent) {
            this.element = element;
            this.children = new HashMap<String, Node>();
            this.parent = parent;
        }

        public Node addChild(String tag) {
            Node child = new Node(tag, this);
            this.children.put(tag, child);
            return child;
        }

        public Node findChild(String tag) {
            return this.children.get(tag);
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeListener getReader() {
            return this.reader;
        }

        public void setReader(NodeListener reader) {
            this.reader = reader;
        }

        @Override
        public int compareTo(Node o) {
            return this.element.compareTo(o.element);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.element == other.element || this.element != null && this.element.equals(other.element);
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + (this.element != null ? this.element.hashCode() : 0);
            return hash;
        }

        public String toString() {
            boolean comma = false;
            StringBuilder buf = new StringBuilder(500);
            buf.append("{ ");
            if (this.element != null && this.element.length() > 0) {
                buf.append(this.element);
                comma = true;
            }
            if (this.parent == null) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append("root");
                comma = true;
            }
            if (this.children.size() > 0) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append(this.children.size());
                buf.append(" sub(s)");
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    public static class Path {
        private final String path;
        private final NodeListener reader;

        public Path(String path) {
            this(path, null);
        }

        public Path(String path, NodeListener reader) {
            this.path = path;
            this.reader = reader;
        }

        public String getPath() {
            return this.path;
        }

        public NodeListener getReader() {
            return this.reader;
        }

        public String toString() {
            return this.path;
        }
    }

    public static abstract class NodeListener {
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
        }

        public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        }

        public void endNode(String qname) throws SAXException {
        }
    }
}

