/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.parser.HttpData;
import org.glassfish.tools.ide.server.parser.TargetConfigMarker;
import org.glassfish.tools.ide.server.parser.TreeParser;
import org.glassfish.tools.ide.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkListenerReader
extends TargetConfigMarker
implements XMLReader {
    public static final String DEFAULT_PATH = "/domain/configs/config/network-config/network-listeners/network-listener";
    private String path;
    private Map<String, HttpData> result;

    public NetworkListenerReader() {
        this(DEFAULT_PATH, "server");
    }

    public NetworkListenerReader(String path, String targetName) {
        super(targetName);
        this.path = path;
        this.result = new HashMap<String, HttpData>();
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (this.readData) {
            try {
                String id = attributes.getValue("name");
                if (id != null && id.length() > 0) {
                    boolean enabled;
                    if (attributes.getValue("port").startsWith("$")) {
                        return;
                    }
                    int port = Integer.parseInt(attributes.getValue("port"));
                    boolean secure = "true".equals(attributes.getValue("security-enabled"));
                    boolean bl = enabled = !"false".equals(attributes.getValue("enabled"));
                    if (enabled) {
                        HttpData data = new HttpData(id, port, secure);
                        Logger.log(Level.INFO, "Adding " + data);
                        this.result.put(id, data);
                    } else {
                        Logger.log(Level.INFO, "http-listener " + id + " is not enabled and won't be used.");
                    }
                } else {
                    Logger.log(Level.INFO, "http-listener found with no name");
                }
            }
            catch (NumberFormatException ex) {
                Logger.log(Level.SEVERE, "Error reading network listener", ex);
            }
        }
    }

    @Override
    public TreeParser.Path[] getPathsToListen() {
        return new TreeParser.Path[]{new TreeParser.Path(this.path, this), new TreeParser.Path("/domain/configs/config", new TargetConfigMarker.TargetMarker(this))};
    }

    public Map<String, HttpData> getResult() {
        return this.result;
    }
}

