/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.parser;

import java.util.logging.Level;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.parser.TargetConfigMarker;
import org.glassfish.tools.ide.server.parser.TreeParser;
import org.glassfish.tools.ide.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JmxConnectorReader
extends TargetConfigMarker
implements XMLReader {
    public static final String DEFAULT_PATH = "/domain/configs/config/admin-service/jmx-connector";
    private String path;
    private String result;

    public JmxConnectorReader() {
        this(DEFAULT_PATH, "server");
    }

    public JmxConnectorReader(String path, String targetName) {
        super(targetName);
        this.path = path;
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (this.readData) {
            String jmxAttr = attributes.getValue("port");
            try {
                int port = Integer.parseInt(jmxAttr);
                this.result = "" + port;
                Logger.log(Level.INFO, "JMX Port is " + this.result);
            }
            catch (NumberFormatException ex) {
                Logger.log(Level.SEVERE, "error reading one jmx port", ex);
            }
        }
    }

    @Override
    public TreeParser.Path[] getPathsToListen() {
        return new TreeParser.Path[]{new TreeParser.Path(this.path, this), new TreeParser.Path("/domain/configs/config", new TargetConfigMarker.TargetMarker(this))};
    }

    public String getResult() {
        return this.result;
    }
}

