/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.tools.ide.server.config.Fileset;
import org.glassfish.tools.ide.server.config.LibraryNode;
import org.glassfish.tools.ide.server.parser.ConfigReaderClasspath;
import org.glassfish.tools.ide.server.parser.ConfigReaderJavadocs;
import org.glassfish.tools.ide.server.parser.ConfigReaderSources;
import org.glassfish.tools.ide.server.parser.TreeParser;
import org.glassfish.tools.ide.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigReaderLibraries
extends TreeParser.NodeListener
implements XMLReader {
    private ConfigReaderClasspath classpathReader = new ConfigReaderClasspath();
    private ConfigReaderJavadocs javadocsReader = new ConfigReaderJavadocs();
    private ConfigReaderSources sourcesReader = new ConfigReaderSources();
    private List<LibraryNode> result = new LinkedList<LibraryNode>();
    private String actualLibID;

    public List<LibraryNode> getResult() {
        return this.result;
    }

    @Override
    public TreeParser.Path[] getPathsToListen() {
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>(7);
        paths.add(new TreeParser.Path("/server/library", this));
        Collections.addAll(paths, this.classpathReader.getPathsToListen());
        Collections.addAll(paths, this.javadocsReader.getPathsToListen());
        Collections.addAll(paths, this.sourcesReader.getPathsToListen());
        TreeParser.Path[] resultPath = new TreeParser.Path[paths.size()];
        paths.toArray(resultPath);
        return resultPath;
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        this.actualLibID = attributes.getValue("id");
    }

    @Override
    public void endNode(String qname) throws SAXException {
        if ("library".equals(qname)) {
            Fileset classpath = new Fileset(this.classpathReader.getPaths(), this.classpathReader.getFilesets());
            Fileset javadocs = new Fileset(this.javadocsReader.getPaths(), this.javadocsReader.getLinks(), this.javadocsReader.getFilesets());
            Fileset sources = new Fileset(this.sourcesReader.getPaths(), this.sourcesReader.getFilesets());
            LibraryNode config = new LibraryNode(this.actualLibID, classpath, javadocs, sources);
            this.result.add(config);
            this.actualLibID = null;
            this.classpathReader.reset();
            this.javadocsReader.reset();
            this.sourcesReader.reset();
        }
    }
}

