/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.config;

import java.net.URL;
import org.glassfish.tools.ide.data.GlassFishVersion;

public class LibraryConfig {
    final URL[] configFiles;
    final int[] index;

    public LibraryConfig(URL defaultConfig, Next ... nextConfig) {
        int indexSize = nextConfig == null ? 1 : nextConfig.length + 1;
        this.index = new int[GlassFishVersion.length];
        this.configFiles = new URL[indexSize];
        int i = 0;
        this.configFiles[i] = defaultConfig;
        Next config = nextConfig != null && i < nextConfig.length ? nextConfig[i] : null;
        for (GlassFishVersion version : GlassFishVersion.values()) {
            int versionIndex = version.ordinal();
            if (config != null && config.version.ordinal() <= version.ordinal()) {
                this.configFiles[++i] = config.configFile;
                config = i < nextConfig.length ? nextConfig[i] : null;
            }
            this.index[versionIndex] = i;
        }
    }

    public static class Next {
        URL configFile;
        GlassFishVersion version;

        public Next(GlassFishVersion version, URL configFile) {
            this.configFile = configFile;
            this.version = version;
        }
    }
}

