/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.data.GlassFishLibrary;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.server.config.GlassFishConfig;
import org.glassfish.tools.ide.server.config.GlassFishConfigManager;
import org.glassfish.tools.ide.server.config.LibraryConfig;
import org.glassfish.tools.ide.server.config.LibraryNode;
import org.glassfish.tools.ide.server.config.LibraryUtils;

public class LibraryBuilder {
    private final LibraryConfig config;
    private final File classpathHome;
    private final File javadocsHome;
    private final File srcHome;
    private volatile List<GlassFishLibrary> cache;

    private static List<GlassFishLibrary> getLibraries(URL config, File classpathHome, File javadocsHome, File srcHome) {
        GlassFishConfig configAdapter = GlassFishConfigManager.getConfig(config);
        LinkedList<GlassFishLibrary> result = new LinkedList<GlassFishLibrary>();
        List<LibraryNode> libConfigs = configAdapter.getLibraryConfigs();
        try {
            for (LibraryNode libConfig : libConfigs) {
                List<File> classpath = LibraryUtils.processFileset(libConfig.classpath, classpathHome.getAbsolutePath());
                List<File> javadocs = LibraryUtils.processFileset(libConfig.javadocs, javadocsHome.getAbsolutePath());
                List<URL> javadocUrls = LibraryUtils.processLinks(libConfig.javadocs);
                List<File> sources = LibraryUtils.processFileset(libConfig.sources, srcHome.getAbsolutePath());
                result.add(new GlassFishLibrary(libConfig.libraryID, LibraryBuilder.buildUrls(classpath), LibraryBuilder.buildUrls(javadocs, javadocUrls), LibraryBuilder.buildUrls(sources), LibraryUtils.processClassPath(classpath)));
            }
        }
        catch (FileNotFoundException e) {
            throw new GlassFishIdeException("Some files required by configuration were not found.", e);
        }
        return result;
    }

    private static List<URL> buildUrls(List<File> files, List<URL> urls) {
        List<URL> result = LibraryBuilder.buildUrls(files);
        result.addAll(urls);
        return result;
    }

    private static List<URL> buildUrls(List<File> files) {
        ArrayList<URL> result = new ArrayList<URL>(files.size());
        for (File file : files) {
            URL url = LibraryUtils.fileToURL(file);
            if (url == null) continue;
            result.add(url);
        }
        return result;
    }

    public LibraryBuilder(LibraryConfig config, String classpathHome, String javadocsHome, String srcHome) {
        this.config = config;
        this.classpathHome = new File(classpathHome);
        this.javadocsHome = new File(javadocsHome);
        this.srcHome = new File(srcHome);
    }

    public LibraryBuilder(LibraryConfig config, File classpathHome, File javadocsHome, File srcHome) {
        this.config = config;
        this.classpathHome = classpathHome;
        this.javadocsHome = javadocsHome;
        this.srcHome = srcHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlassFishLibrary> getLibraries(GlassFishVersion version) {
        if (this.cache != null) {
            return this.cache;
        }
        LibraryBuilder libraryBuilder = this;
        synchronized (libraryBuilder) {
            if (this.cache == null) {
                this.cache = LibraryBuilder.getLibraries(this.config.configFiles[this.config.index[version.ordinal()]], this.classpathHome, this.javadocsHome, this.srcHome);
            }
        }
        return this.cache;
    }
}

