/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.CommandDeploy;
import org.glassfish.tools.ide.admin.CommandStartCluster;
import org.glassfish.tools.ide.admin.CommandStartDAS;
import org.glassfish.tools.ide.admin.CommandStartInstance;
import org.glassfish.tools.ide.admin.CommandStopCluster;
import org.glassfish.tools.ide.admin.CommandStopDAS;
import org.glassfish.tools.ide.admin.CommandStopInstance;
import org.glassfish.tools.ide.admin.ResultProcess;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskStateListener;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.data.StartupArgs;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.parser.JvmConfigReader;
import org.glassfish.tools.ide.server.parser.TreeParser;
import org.glassfish.tools.ide.utils.JavaUtils;
import org.glassfish.tools.ide.utils.OsUtils;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.glassfish.tools.ide.utils.Utils;

public class ServerTasks {
    private static final String DAS_NAME = "server";

    public static ResultProcess startServer(GlassFishServer server, StartupArgs args, StartMode mode) throws GlassFishIdeException {
        File bootstrapJar;
        JvmConfigReader jvmConfigReader = new JvmConfigReader(DAS_NAME);
        String domainAbsolutePath = server.getDomainsFolder() + File.separator + server.getDomainName();
        String domainXmlPath = domainAbsolutePath + File.separator + "config" + File.separator + "domain.xml";
        if (!TreeParser.readXml(new File(domainXmlPath), jvmConfigReader)) {
            throw new GlassFishIdeException("Unable to read jvm configuration from " + domainXmlPath);
        }
        List<String> optList = jvmConfigReader.getOptList();
        Map<String, String> propMap = jvmConfigReader.getPropMap();
        File irf = new File(server.getServerHome());
        File btrace = new File(irf, "lib/monitor/btrace-agent.jar");
        if (btrace.exists() && jvmConfigReader.isMonitoringEnabled()) {
            optList.add("-javaagent:" + Utils.quote(btrace.getAbsolutePath()) + "=unsafe=true,noServer=true");
        }
        if ((bootstrapJar = ServerUtils.getJarName(server.getServerHome(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar")) == null) {
            throw new GlassFishIdeException("unable to find bootstrap jar!");
        }
        String classPath = ServerTasks.computeClassPath(propMap, new File(domainAbsolutePath), bootstrapJar);
        StringBuilder javaOpts = new StringBuilder(1024);
        StringBuilder glassfishArgs = new StringBuilder(256);
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("com.sun.aas.installRoot", Utils.escapePath(server.getServerHome()));
        varMap.put("com.sun.aas.instanceRoot", Utils.escapePath(domainAbsolutePath));
        varMap.put("com.sun.aas.javaRoot", Utils.escapePath(args.getJavaHome()));
        varMap.put("com.sun.aas.derbyRoot", server.getServerHome() + File.separator + "javadb");
        if (mode.equals((Object)StartMode.DEBUG)) {
            String debugOpts = propMap.get("debug-options");
            String[] debugOptsSplited = debugOpts.split("\\s+(?=-)");
            optList.addAll(Arrays.asList(debugOptsSplited));
        }
        if (mode.equals((Object)StartMode.PROFILE)) {
            // empty if block
        }
        if (args != null) {
            if (args.getJavaArgs() != null) {
                optList.addAll(args.getJavaArgs());
            }
            ServerTasks.appendOptions(javaOpts, optList, varMap);
            if (args.getGlassfishArgs() != null) {
                ServerTasks.appendGlassfishArgs(glassfishArgs, args.getGlassfishArgs());
            }
        }
        CommandStartDAS startCommand = new CommandStartDAS(args.getJavaHome(), classPath, javaOpts.toString(), glassfishArgs.toString(), domainAbsolutePath);
        Future future = ServerAdmin.exec(server, startCommand, new IdeContext());
        try {
            return (ResultProcess)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("DAS start failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("DAS start failed.", e);
        }
    }

    public static ResultProcess startServer(GlassFishServer server, StartupArgs args) throws GlassFishIdeException {
        return ServerTasks.startServer(server, args, StartMode.START);
    }

    public static ResultString stopServer(GlassFishServer server) throws GlassFishIdeException {
        CommandStopDAS command = new CommandStopDAS();
        Future future = ServerAdmin.exec(server, command, new IdeContext());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("DAS stop failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("DAS stop failed.", e);
        }
    }

    public static ResultString startServerInstance(GlassFishServer server, String target) {
        CommandStartInstance command = new CommandStartInstance(target);
        Future future = ServerAdmin.exec(server, command, new IdeContext());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Instance or cluster start failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Instance or cluster start failed.", e);
        }
    }

    public static ResultString stopServerInstance(GlassFishServer server, String target) {
        CommandStopInstance command = new CommandStopInstance(target);
        Future future = ServerAdmin.exec(server, command, new IdeContext());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
    }

    public static ResultString startCluster(GlassFishServer server, String target) {
        CommandStartCluster command = new CommandStartCluster(target);
        Future future = ServerAdmin.exec(server, command, new IdeContext());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Instance or cluster start failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Instance or cluster start failed.", e);
        }
    }

    public static ResultString stopCluster(GlassFishServer server, String target) {
        CommandStopCluster command = new CommandStopCluster(target);
        Future future = ServerAdmin.exec(server, command, new IdeContext());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
    }

    public static ResultString deploy(GlassFishServer server, File application, TaskStateListener listener) {
        CommandDeploy command = new CommandDeploy(null, null, application, null, null, null);
        Future future = ServerAdmin.exec(server, command, new IdeContext(), listener);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
        catch (ExecutionException e) {
            throw new GlassFishIdeException("Instance or cluster stop failed.", e);
        }
    }

    private static String computeClassPath(Map<String, String> propMap, File domainDir, File bootstrapJar) {
        String result = null;
        List<File> prefixCP = Utils.classPathToFileList(propMap.get("classpath-prefix"), domainDir);
        List<File> suffixCP = Utils.classPathToFileList(propMap.get("classpath-suffix"), domainDir);
        boolean useEnvCP = "false".equals(propMap.get("env-classpath-ignored"));
        List<File> envCP = Utils.classPathToFileList(useEnvCP ? System.getenv("CLASSPATH") : null, domainDir);
        List<File> systemCP = Utils.classPathToFileList(propMap.get("system-classpath"), domainDir);
        if (prefixCP.size() > 0 || suffixCP.size() > 0 || envCP.size() > 0 || systemCP.size() > 0) {
            List<File> mainCP = Utils.classPathToFileList(bootstrapJar.getAbsolutePath(), null);
            if (mainCP.size() > 0) {
                ArrayList<File> completeCP = new ArrayList<File>(32);
                completeCP.addAll(prefixCP);
                completeCP.addAll(mainCP);
                completeCP.addAll(systemCP);
                completeCP.addAll(envCP);
                completeCP.addAll(suffixCP);
                StringBuilder classPath = new StringBuilder(1024);
                Iterator iter = completeCP.iterator();
                classPath.append(Utils.quote(((File)iter.next()).getPath()));
                while (iter.hasNext()) {
                    classPath.append(File.pathSeparatorChar);
                    classPath.append(Utils.quote(((File)iter.next()).getPath()));
                }
                result = classPath.toString();
            } else {
                Logger.log(Level.WARNING, "Unable to read main classpath from glassfish main jar when building launch classpath.");
            }
        }
        return result;
    }

    private static void appendOptions(StringBuilder argumentBuf, List<String> optList, Map<String, String> varMap) {
        String value;
        HashMap<String, String> keyValueArgs = new HashMap<String, String>();
        LinkedList<String> keyOrder = new LinkedList<String>();
        for (String opt : optList) {
            String name;
            int splitIndex = (opt = Utils.doSub(opt.trim(), varMap)).indexOf(61);
            if (splitIndex != -1 && !opt.startsWith("-agentpath:")) {
                name = opt.substring(0, splitIndex);
                value = Utils.quote(opt.substring(splitIndex + 1));
                Logger.log(Level.FINER, "DOMAIN.XML: jvm opt: " + name + " = " + value);
            } else {
                name = opt;
                value = null;
                Logger.log(Level.FINER, "DOMAIN.XML: jvm opt: " + name);
            }
            if (!keyValueArgs.containsKey(name)) {
                keyOrder.add(name);
            }
            keyValueArgs.put(name, value);
        }
        String[] PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
        boolean isWindows = OsUtils.isWin();
        for (String prop : PROXY_PROPS) {
            value = System.getProperty(prop);
            if (value == null || value.trim().length() <= 0) continue;
            if (isWindows && "http.nonProxyHosts".equals(prop)) {
                value = "\"" + value + "\"";
            }
            keyValueArgs.put(JavaUtils.systemPropertyName(prop), value);
        }
        for (String key : keyOrder) {
            argumentBuf.append(' ');
            argumentBuf.append(key);
            if (keyValueArgs.get(key) == null) continue;
            argumentBuf.append("=");
            argumentBuf.append((String)keyValueArgs.get(key));
        }
    }

    private static void appendGlassfishArgs(StringBuilder glassfishArgs, List<String> glassfishArgsList) {
        for (String arg : glassfishArgsList) {
            glassfishArgs.append(' ');
            glassfishArgs.append(arg);
        }
        if (glassfishArgs.length() > 0) {
            glassfishArgs.deleteCharAt(0);
        }
    }

    public static enum StartMode {
        START,
        DEBUG,
        PROFILE;

    }
}

