/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.tools.ide.admin.CommandLocation;
import org.glassfish.tools.ide.admin.CommandVersion;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;

public class ServerStatus
implements Closeable {
    private static final int EXECUTOR_POOL_SIZE = 2;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int COMAND_TIMEOUT_MIN = 100;
    private static final int COMAND_TIMEOUT = 30000;
    private static final int COMAND_STARTUP_TIMEOUT = 600000;
    private final ExecutorService executor = ServerAdmin.executor(2);
    private final AdminPortTask adminPortTask;
    private final VersionTask versionTask;
    private final LocationsTask locationsTask;

    public ServerStatus(GlassFishServer server, boolean startup) {
        this.adminPortTask = new AdminPortTask(server, 15000);
        this.versionTask = new VersionTask(server, startup);
        this.locationsTask = new LocationsTask(server, startup);
    }

    public Result getAdminPortResult() {
        return this.adminPortTask.result;
    }

    public ResultVersion getVersionResult() {
        return this.versionTask.result;
    }

    public ResultLocations getLocationsResult() {
        return this.locationsTask.result;
    }

    public GlassFishVersion getVersion() {
        Pattern p;
        Matcher m;
        String versionStr;
        String string = versionStr = this.versionTask.result != null && ((VersionTask)this.versionTask).result.result != null ? ((VersionTask)this.versionTask).result.result.getValue() : null;
        if (versionStr != null && (m = (p = Pattern.compile("[0-9]+(\\.[0-9]+){1,3}")).matcher(versionStr)).find()) {
            String versionToken = versionStr.substring(m.start(), m.end());
            return GlassFishVersion.toValue(versionToken);
        }
        return null;
    }

    public void check() {
        this.versionTask.start(this.executor);
        this.locationsTask.start(this.executor);
        Result result = this.adminPortTask.check();
        if (result.status != Status.SUCCESS) {
            this.versionTask.cancel();
            this.locationsTask.cancel();
        }
        this.versionTask.join();
        this.locationsTask.join();
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private static class VersionTask
    extends Task {
        private final CommandVersion command = new CommandVersion();
        private Future<ResultString> future;
        ResultString taskResult;
        private ResultVersion result;
        private final boolean startup;

        VersionTask(GlassFishServer server, boolean startup) {
            super(server);
            this.startup = startup;
        }

        ResultVersion getResult() {
            return this.result;
        }

        void start(ExecutorService executor) {
            this.tmStart = System.currentTimeMillis();
            this.future = ServerAdmin.exec(executor, this.server, this.command, new IdeContext());
            if (this.tmStart >= 0L && Logger.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                Logger.log(Level.FINE, "[{0}] Version task started.", VersionTask.tm(tm));
            }
        }

        private void logExceptionOnJoin(Exception ex) {
            Logger.log(Level.FINE, "[{0}] Version task failed: {1} {2}", new Object[]{VersionTask.tm(System.currentTimeMillis() - this.tmStart), ex.getClass().getName(), ex.getMessage() != null ? ex.getMessage() : ""});
        }

        void join() {
            try {
                this.taskResult = this.future.get(this.timeout(this.startup), TimeUnit.MILLISECONDS);
                this.result = new ResultVersion(this.taskResult, Status.SUCCESS);
                Logger.log(Level.FINE, "[{0}] Version task completed.", VersionTask.tm(System.currentTimeMillis() - this.tmStart));
            }
            catch (TimeoutException te) {
                this.result = new ResultVersion(Status.TIMEOUT);
                this.logExceptionOnJoin(te);
            }
            catch (ExecutionException ee) {
                this.result = new ResultVersion(Status.FATAL, ee);
                this.logExceptionOnJoin(ee);
            }
            catch (InterruptedException ie) {
                this.result = new ResultVersion(Status.FAILED, ie);
                this.logExceptionOnJoin(ie);
            }
            catch (CancellationException ce) {
                this.result = new ResultVersion(Status.FAILED, ce);
                this.logExceptionOnJoin(ce);
            }
        }

        void cancel() {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
        }
    }

    private static class LocationsTask
    extends Task {
        private final CommandLocation command = new CommandLocation();
        private Future<ResultMap<String, String>> future;
        ResultMap<String, String> taskResult;
        private ResultLocations result;
        private final boolean startup;

        LocationsTask(GlassFishServer server, boolean startup) {
            super(server);
            this.startup = startup;
        }

        ResultLocations getResult() {
            return this.result;
        }

        void start(ExecutorService executor) {
            this.tmStart = System.currentTimeMillis();
            this.future = ServerAdmin.exec(executor, this.server, this.command, new IdeContext());
            if (this.tmStart >= 0L && Logger.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                Logger.log(Level.FINE, "[{0}] Locations task started.", LocationsTask.tm(tm));
            }
        }

        private void logExceptionOnJoin(Exception ex) {
            Logger.log(Level.FINE, "[{0}] Locations task failed: {1} {2}", new Object[]{LocationsTask.tm(System.currentTimeMillis() - this.tmStart), ex.getClass().getName(), ex.getMessage() != null ? ex.getMessage() : ""});
        }

        void join() {
            try {
                this.taskResult = this.future.get(this.timeout(this.startup), TimeUnit.MILLISECONDS);
                this.result = new ResultLocations(this.taskResult, Status.SUCCESS);
                Logger.log(Level.FINE, "[{0}] Locations task completed.", LocationsTask.tm(System.currentTimeMillis() - this.tmStart));
            }
            catch (TimeoutException te) {
                this.result = new ResultLocations(Status.TIMEOUT);
                this.logExceptionOnJoin(te);
            }
            catch (ExecutionException ee) {
                this.result = new ResultLocations(Status.FATAL, ee);
                this.logExceptionOnJoin(ee);
            }
            catch (InterruptedException ie) {
                this.result = new ResultLocations(Status.FAILED, ie);
                this.logExceptionOnJoin(ie);
            }
            catch (CancellationException ce) {
                this.result = new ResultLocations(Status.FAILED, ce);
                this.logExceptionOnJoin(ce);
            }
        }

        void cancel() {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
        }
    }

    private static class AdminPortTask
    extends Task {
        private static final String LOG_TIME_PREFIX = "[{4}] ";
        String host;
        int port;
        int timeout;
        private Result result;

        AdminPortTask(GlassFishServer server, int timeout) {
            super(server);
            this.host = server.getHost();
            this.port = server.getAdminPort();
            this.timeout = timeout;
        }

        Result getResult() {
            return this.result;
        }

        private void closeSocket(Socket socket) {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, this.host, this.port, "Socket closing failed when connecting to {0}:{1}: {2}");
            }
        }

        private void handleIOException(IOException ioe, String host, int port, String message) {
            if (this.tmStart >= 0L && Logger.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                StringBuilder sb = new StringBuilder(LOG_TIME_PREFIX.length() + message.length());
                sb.append(LOG_TIME_PREFIX);
                sb.append(message);
                Logger.log(Level.FINE, sb.toString(), new Object[]{this.server.getName(), host, Integer.toString(port), ioe.getMessage(), AdminPortTask.tm(tm)});
            } else {
                Logger.log(Level.INFO, message, new Object[]{this.server.getName(), host, Integer.toString(port), ioe.getMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result check() {
            if (this.port < 0 || this.host == null) {
                this.result = new Result(Status.INVALID);
                return this.result;
            }
            this.tmStart = System.currentTimeMillis();
            InetSocketAddress sa = new InetSocketAddress(this.host, this.port);
            Socket socket = new Socket();
            try {
                socket.connect(sa, this.timeout);
                socket.setSoTimeout(this.timeout);
            }
            catch (ConnectException ce) {
                this.handleIOException(ce, this.host, this.port, "[{0}] Port check could not connect to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.FAILED, ce);
                return result;
            }
            catch (SocketTimeoutException ste) {
                this.handleIOException(ste, this.host, this.port, "[{0}] Port check timeout when connecting to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.TIMEOUT, ste);
                return result;
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, this.host, this.port, "[{0}] Port check caught IO exception when connecting to {1}:{2}: {3}");
                Result result = this.result = new Result(Status.EXCEPTION, ioe);
                return result;
            }
            finally {
                this.closeSocket(socket);
            }
            if (this.tmStart >= 0L && Logger.isLoggable(Level.FINE)) {
                long tm = System.currentTimeMillis() - this.tmStart;
                Logger.log(Level.FINE, "[{0} {1}] Port status check succeeded.", new Object[]{AdminPortTask.tm(tm), this.server.getName()});
            }
            this.result = new Result(Status.SUCCESS);
            return this.result;
        }
    }

    private static abstract class Task {
        final GlassFishServer server;
        long tmStart;

        static String tm(long tm) {
            StringBuilder sb = new StringBuilder(8);
            sb.append(Long.toString(tm / 1000L));
            sb.append('.');
            sb.append(Long.toString(tm % 1000L));
            return sb.toString();
        }

        Task(GlassFishServer server) {
            this.server = server;
            this.tmStart = -1L;
        }

        long timeout(boolean startup) {
            long timeout = (long)(startup ? 600000 : 30000) - System.currentTimeMillis() + this.tmStart;
            if (timeout > 100L) {
                return timeout;
            }
            return 100L;
        }
    }

    public static class ResultVersion
    extends Result {
        final ResultString result;

        ResultVersion(ResultString result, Status status) {
            super(status);
            this.result = result;
        }

        ResultVersion(Status status, Exception ex) {
            super(status, ex);
            this.result = null;
        }

        ResultVersion(Status status) {
            super(status);
            this.result = null;
        }

        public ResultString getResult() {
            return this.result;
        }
    }

    public static class ResultLocations
    extends Result {
        final ResultMap<String, String> result;

        ResultLocations(ResultMap<String, String> result, Status status) {
            super(status);
            this.result = result;
        }

        ResultLocations(Status status, Exception ex) {
            super(status, ex);
            this.result = null;
        }

        ResultLocations(Status status) {
            super(status);
            this.result = null;
        }

        public ResultMap<String, String> getResult() {
            return this.result;
        }
    }

    public static class Result {
        final Status status;
        private final IOException ioe;
        private final Exception ex;

        Result(Status status, IOException ioe) {
            this.status = status;
            this.ioe = ioe;
            this.ex = null;
        }

        Result(Status status, Exception ex) {
            this.status = status;
            this.ioe = null;
            this.ex = ex;
        }

        Result(Status status) {
            this.status = status;
            this.ioe = null;
            this.ex = null;
        }

        public Status getStatus() {
            return this.status;
        }
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        TIMEOUT,
        EXCEPTION,
        INVALID,
        FATAL;


        public String toString() {
            switch (this) {
                case SUCCESS: {
                    return "SUCCESS";
                }
                case FAILED: {
                    return "FAILED";
                }
                case TIMEOUT: {
                    return "TIMEOUT";
                }
                case EXCEPTION: {
                    return "EXCEPTION";
                }
                case INVALID: {
                    return "INVALID";
                }
                case FATAL: {
                    return "FATAL";
                }
            }
            throw new IllegalStateException("Unknown Status value");
        }
    }
}

