/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.CommandFetchLogData;
import org.glassfish.tools.ide.admin.ResultLog;
import org.glassfish.tools.ide.admin.ServerAdmin;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.FetchLogPiped;
import org.glassfish.tools.ide.utils.OsUtils;

public class FetchLogRemote
extends FetchLogPiped {
    FetchLogRemote(GlassFishServer server, boolean skip) {
        super(server, skip);
    }

    @Override
    public TaskState call() {
        IdeContext ctx = new IdeContext();
        Future future = ServerAdmin.exec(this.server, new CommandFetchLogData(), ctx);
        try {
            ResultLog result = (ResultLog)future.get();
            if (!this.skip && result.getState() == TaskState.COMPLETED) {
                for (String line : result.getValue().getLines()) {
                    this.out.write(line.getBytes());
                    this.out.write(OsUtils.LINES_SEPARATOR.getBytes());
                }
                this.out.flush();
            }
            byte[] lineSeparatorOut = OsUtils.LINES_SEPARATOR.getBytes();
            while (this.taksExecute && result.getState() == TaskState.COMPLETED) {
                future = ServerAdmin.exec(this.server, new CommandFetchLogData(result.getValue().getParamsAppendNext()), ctx);
                if ((result = (ResultLog)future.get()).getState() == TaskState.COMPLETED) {
                    for (String line : result.getValue().getLines()) {
                        byte[] lineOut = line.getBytes();
                        Logger.log(Level.FINEST, "Read {0} bytes from remote log file.", new Object[]{new Integer(lineOut.length + lineSeparatorOut.length)});
                        this.out.write(lineOut);
                        this.out.write(lineSeparatorOut);
                    }
                    this.out.flush();
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ie) {
            Logger.log(Level.INFO, "Caught InterruptedException: " + ie.getMessage());
            Thread.currentThread().interrupt();
            return TaskState.COMPLETED;
        }
        catch (ExecutionException ee) {
            Logger.log(Level.WARNING, "Caught ExecutionException: ", ee);
            return TaskState.FAILED;
        }
        catch (InterruptedIOException ie) {
            Logger.log(Level.INFO, "Caught InterruptedIOException: " + ie.getMessage());
            Thread.currentThread().interrupt();
            return TaskState.COMPLETED;
        }
        catch (IOException ioe) {
            if (this.taksExecute) {
                Logger.log(Level.WARNING, "Caught IOException: ", ioe);
                return TaskState.FAILED;
            }
            Logger.log(Level.INFO, "Caught IOException: " + ioe.getMessage());
            return TaskState.COMPLETED;
        }
        return TaskState.COMPLETED;
    }
}

