/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.FetchLog;
import org.glassfish.tools.ide.server.FetchLogException;

public abstract class FetchLogPiped
extends FetchLog
implements Callable<TaskState> {
    static final int PIPE_BUFFER_SIZE = 8192;
    static final int LOG_REFRESH_DELAY = 1000;
    final PipedOutputStream out;
    final Future<TaskState> task;
    private ExecutorService executor;
    volatile boolean taksExecute;

    FetchLogPiped(final GlassFishServer server, boolean skip) {
        super(server, skip);
        try {
            this.out = new PipedOutputStream((PipedInputStream)this.in);
        }
        catch (IOException ioe) {
            super.close();
            throw new FetchLogException("Cannot initialize output stream", ioe);
        }
        this.taksExecute = true;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, FetchLogPiped.class.getName() + server.getUrl());
                t.setDaemon(true);
                return t;
            }
        });
        this.task = this.executor.submit(this);
    }

    @Override
    InputStream initInputStream() {
        return new PipedInputStream(8192);
    }

    private TaskState stop() {
        TaskState result;
        this.taksExecute = false;
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, "Cannot close output stream: ", ioe);
            }
        } else {
            Logger.log(Level.INFO, "Output stream is null.");
        }
        try {
            result = this.task.get();
        }
        catch (InterruptedException ie) {
            throw new FetchLogException("Reader task was interrupted", ie);
        }
        catch (ExecutionException ee) {
            throw new FetchLogException("Reader task thrown an exception", ee);
        }
        catch (CancellationException ce) {
            throw new FetchLogException("Reader task was canceled", ce);
        }
        return result;
    }

    @Override
    public void close() {
        TaskState result = this.stop();
        super.close();
        if (result != TaskState.COMPLETED) {
            Logger.log(Level.WARNING, "Log lines reading task execution failed.");
        }
    }

    public boolean isRunning() {
        return !this.task.isDone();
    }
}

