/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.FetchLogException;
import org.glassfish.tools.ide.server.FetchLogPiped;
import org.glassfish.tools.ide.utils.OsUtils;

public class FetchLogLocal
extends FetchLogPiped {
    static String LOGS_DIR = "logs";
    static String LOGS_FILE = "server.log";

    static String serverLogFile() {
        StringBuilder sb = new StringBuilder(LOGS_DIR.length() + File.separator.length() + LOGS_FILE.length());
        sb.append(LOGS_DIR);
        sb.append(File.separator);
        sb.append(LOGS_FILE);
        return sb.toString();
    }

    static String serverDomainDir(GlassFishServer server) {
        String domainName = server.getDomainName();
        String domainsFolder = server.getDomainsFolder();
        boolean appendSeparator = domainsFolder.lastIndexOf(File.separator) + OsUtils.FILE_SEPARATOR_LENGTH != domainsFolder.length();
        StringBuilder sb = new StringBuilder(server.getDomainsFolder().length() + (appendSeparator ? OsUtils.FILE_SEPARATOR_LENGTH : 0) + domainName.length());
        sb.append(domainsFolder);
        if (appendSeparator) {
            sb.append(File.separator);
        }
        sb.append(domainName);
        return sb.toString();
    }

    FetchLogLocal(GlassFishServer server, boolean skip) {
        super(server, skip);
    }

    private File logFile() {
        return new File(FetchLogLocal.serverDomainDir(this.server), FetchLogLocal.serverLogFile());
    }

    private InputStream initInputFile() {
        FileInputStream log;
        File logFile = this.logFile();
        try {
            log = new FileInputStream(logFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new FetchLogException("Cannot initialize input stream", fnfe);
        }
        if (this.skip) {
            try {
                int count;
                while ((count = ((InputStream)log).available()) > 0) {
                    ((InputStream)log).skip(count);
                }
            }
            catch (IOException ioe) {
                try {
                    ((InputStream)log).close();
                }
                catch (IOException ioec) {
                    Logger.log(Level.WARNING, "Cannot close input stream: ", ioec);
                }
                throw new FetchLogException("Cannot initialize input stream", ioe);
            }
        }
        return log;
    }

    @Override
    public TaskState call() {
        InputStream fIn = this.initInputFile();
        byte[] buff = new byte[8192];
        File logFile = this.logFile();
        while (this.taksExecute) {
            try {
                int inCount = fIn.available();
                long lastModified = logFile.lastModified();
                if (inCount <= 0) {
                    Thread.sleep(1000L);
                    inCount = fIn.available();
                    if (inCount <= 0 && logFile.lastModified() > lastModified) {
                        Logger.log(Level.FINER, "Log rotation dedected, switching stream.");
                        fIn.close();
                        fIn = this.initInputFile();
                    }
                }
                if (inCount <= 0) continue;
                while (inCount > 0) {
                    int count = fIn.read(buff);
                    Logger.log(Level.FINEST, "Read {0} bytes from local log file.", new Object[]{new Integer(count)});
                    this.out.write(buff, 0, count);
                    if ((inCount -= count) > 0) continue;
                    inCount = fIn.available();
                }
                this.out.flush();
            }
            catch (InterruptedException ie) {
                Logger.log(Level.INFO, "Caught InterruptedException: " + ie.getMessage());
                Thread.currentThread().interrupt();
                return TaskState.COMPLETED;
            }
            catch (InterruptedIOException ie) {
                Logger.log(Level.INFO, "Caught InterruptedIOException: " + ie.getMessage());
                Thread.currentThread().interrupt();
                return TaskState.COMPLETED;
            }
            catch (IOException ioe) {
                if (this.taksExecute) {
                    Logger.log(Level.WARNING, "Caught IOException: ", ioe);
                    return TaskState.FAILED;
                }
                Logger.log(Level.INFO, "Caught IOException: " + ioe.getMessage());
                return TaskState.COMPLETED;
            }
        }
        return TaskState.COMPLETED;
    }
}

