/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.server.FetchLogLocal;
import org.glassfish.tools.ide.server.FetchLogPiped;
import org.glassfish.tools.ide.server.FetchLogRemote;

public abstract class FetchLog {
    GlassFishServer server;
    final InputStream in;
    final boolean skip;

    public static FetchLog create(GlassFishServer server, boolean skip) {
        boolean isLocal = server.getDomainsFolder() != null && server.getDomainName() != null;
        FetchLogPiped fetchLog = isLocal ? new FetchLogLocal(server, skip) : new FetchLogRemote(server, skip);
        return fetchLog;
    }

    public static FetchLog create(GlassFishServer server) {
        boolean isLocal = server.getDomainsFolder() != null && server.getDomainName() != null;
        FetchLogPiped fetchLog = isLocal ? new FetchLogLocal(server, false) : new FetchLogRemote(server, false);
        return fetchLog;
    }

    abstract InputStream initInputStream();

    FetchLog(InputStream in, boolean skip) {
        this.server = null;
        this.in = in;
        this.skip = skip;
    }

    FetchLog(GlassFishServer server, boolean skip) {
        this.server = server;
        this.in = this.initInputStream();
        this.skip = skip;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, "Cannot close input stream: ", ioe);
            }
        } else {
            Logger.log(Level.INFO, "Input stream is null.");
        }
    }
}

