/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.data;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.tools.ide.data.DataException;

public enum GlassFishVersion {
    GF_1,
    GF_2,
    GF_2_1,
    GF_2_1_1,
    GF_3,
    GF_3_0_1,
    GF_3_1,
    GF_3_1_1,
    GF_3_1_2,
    GF_3_1_2_2,
    GF_3_1_2_3,
    GF_3_1_2_4,
    GF_4,
    GF_DEVEL;

    public static final int length;
    public static final char SEPARATOR = '.';
    static final String GF_1_STR = "1";
    static final String[] GF_1_STR_NEXT;
    static final String GF_2_STR = "2";
    static final String[] GF_2_STR_NEXT;
    static final String GF_2_1_STR = "2.1";
    static final String[] GF_2_1_STR_NEXT;
    static final String GF_2_1_1_STR = "2.1.1";
    static final String[] GF_2_1_1_STR_NEXT;
    static final String GF_3_STR = "3";
    static final String[] GF_3_STR_NEXT;
    static final String GF_3_0_1_STR = "3.0.1";
    static final String[] GF_3_0_1_STR_NEXT;
    static final String GF_3_1_STR = "3.1";
    static final String[] GF_3_1_STR_NEXT;
    static final String GF_3_1_1_STR = "3.1.1";
    static final String[] GF_3_1_1_STR_NEXT;
    static final String GF_3_1_2_STR = "3.1.2";
    static final String[] GF_3_1_2_STR_NEXT;
    static final String GF_3_1_2_2_STR = "3.1.2.2";
    static final String GF_3_1_2_3_STR = "3.1.2.3";
    static final String GF_3_1_2_4_STR = "3.1.2.4";
    static final String GF_4_STR = "4";
    static final String[] GF_4_STR_NEXT;
    static final String GF_DEVEL_STR = "DEVELOPMENT";
    static final String[] GF_DEVEL_STR_NEXT;
    private static final Map<String, GlassFishVersion> stringValuesMap;

    private static void initStringValuesMapFromArray(GlassFishVersion version, String[] values) {
        for (String value : values) {
            stringValuesMap.put(value, version);
        }
    }

    public static GlassFishVersion toValue(String versionStr) {
        if (versionStr != null) {
            GlassFishVersion version = stringValuesMap.get(versionStr.toUpperCase());
            if (version == null) {
                String[] versionNumbers = versionStr.split("\\.");
                for (int i = versionNumbers.length - 1; version == null && i > 0; --i) {
                    int versionStrLen = i - 1;
                    for (int j = 0; j < i; ++j) {
                        versionStrLen += versionNumbers[j].length();
                    }
                    StringBuilder sb = new StringBuilder(versionStrLen);
                    for (int j = 0; j < i; ++j) {
                        if (j > 0) {
                            sb.append('.');
                        }
                        sb.append(versionNumbers[j]);
                    }
                    version = stringValuesMap.get(sb.toString().toUpperCase());
                }
            }
            return version;
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case GF_1: {
                return GF_1_STR;
            }
            case GF_2: {
                return GF_2_STR;
            }
            case GF_2_1: {
                return GF_2_1_STR;
            }
            case GF_2_1_1: {
                return GF_2_1_1_STR;
            }
            case GF_3: {
                return GF_3_STR;
            }
            case GF_3_0_1: {
                return GF_3_0_1_STR;
            }
            case GF_3_1: {
                return GF_3_1_STR;
            }
            case GF_3_1_1: {
                return GF_3_1_1_STR;
            }
            case GF_3_1_2: {
                return GF_3_1_2_STR;
            }
            case GF_3_1_2_2: {
                return GF_3_1_2_2_STR;
            }
            case GF_3_1_2_3: {
                return GF_3_1_2_3_STR;
            }
            case GF_3_1_2_4: {
                return GF_3_1_2_4_STR;
            }
            case GF_4: {
                return GF_4_STR;
            }
            case GF_DEVEL: {
                return GF_DEVEL_STR;
            }
        }
        throw new DataException("Invalid GlassFish version");
    }

    static {
        length = GlassFishVersion.values().length;
        GF_1_STR_NEXT = new String[]{"1.0", "1.0.0", "1.0.0.0"};
        GF_2_STR_NEXT = new String[]{"2.0", "2.0.0", "2.0.0.0"};
        GF_2_1_STR_NEXT = new String[]{"2.1.0", "2.1.0.0"};
        GF_2_1_1_STR_NEXT = new String[]{"2.1.1.0"};
        GF_3_STR_NEXT = new String[]{"3.0", "3.0.0", "3.0.0.0"};
        GF_3_0_1_STR_NEXT = new String[]{"3.0.1.0"};
        GF_3_1_STR_NEXT = new String[]{"3.1.0", "3.1.0.0"};
        GF_3_1_1_STR_NEXT = new String[]{"3.1.1.0"};
        GF_3_1_2_STR_NEXT = new String[]{"3.1.2.0"};
        GF_4_STR_NEXT = new String[]{"4.0", "4.0.0", "4.0.0.0"};
        GF_DEVEL_STR_NEXT = new String[]{"0", "0.0", "0.0.0", "0.0.0.0"};
        stringValuesMap = new HashMap<String, GlassFishVersion>(2 * GlassFishVersion.values().length);
        for (GlassFishVersion state : GlassFishVersion.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
        GlassFishVersion.initStringValuesMapFromArray(GF_1, GF_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2, GF_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1, GF_2_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1_1, GF_2_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3, GF_3_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_0_1, GF_3_0_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1, GF_3_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_1, GF_3_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_2, GF_3_1_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4, GF_4_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_DEVEL, GF_DEVEL_STR_NEXT);
    }
}

