/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.data;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.tools.ide.data.DataException;

public enum GlassFishContainer implements Comparator<GlassFishContainer>
{
    EAR,
    JRUBY,
    WEB,
    EJB,
    APPCLIENT,
    CONNECTOR,
    UNKNOWN;

    static final String EAR_STR = "ear";
    static final String JRUBY_STR = "jruby";
    static final String WEB_STR = "web";
    static final String EJB_STR = "ejb";
    static final String APPCLIENT_STR = "appclient";
    static final String CONNECTOR_STR = "connector";
    static final String UNKNOWN_STR = "unknown";
    public static final char SEPARATOR = ',';
    private static final Map<String, GlassFishContainer> stringValuesMap;

    public static GlassFishContainer toValue(String containerStr) {
        if (containerStr != null) {
            return stringValuesMap.get(containerStr.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case EAR: {
                return EAR_STR;
            }
            case JRUBY: {
                return JRUBY_STR;
            }
            case WEB: {
                return WEB_STR;
            }
            case EJB: {
                return EJB_STR;
            }
            case APPCLIENT: {
                return APPCLIENT_STR;
            }
            case CONNECTOR: {
                return CONNECTOR_STR;
            }
            case UNKNOWN: {
                return UNKNOWN_STR;
            }
        }
        throw new DataException("Invalid GlassFish container");
    }

    @Override
    public int compare(GlassFishContainer container1, GlassFishContainer container2) {
        return container1 != null && container2 != null ? container1.ordinal() - container2.ordinal() : (container1 != null ? container2.ordinal() : (container2 != null ? -container1.ordinal() : 0));
    }

    static {
        stringValuesMap = new HashMap<String, GlassFishContainer>(2 * GlassFishContainer.values().length);
        for (GlassFishContainer container : GlassFishContainer.values()) {
            stringValuesMap.put(container.toString().toUpperCase(), container);
        }
    }
}

