/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin.response;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.response.ActionReport;
import org.glassfish.tools.ide.admin.response.MessagePart;
import org.glassfish.tools.ide.admin.response.RestActionReport;
import org.glassfish.tools.ide.admin.response.RestResponseParser;

public class RestXMLResponseParser
extends RestResponseParser {
    private static final String ENTRY = "entry";
    private static final String MAP = "map";
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();
    private static final RestXMLResponseFilter filter = new RestXMLResponseFilter();

    @Override
    public RestActionReport parse(InputStream in) {
        try {
            XMLEventReader reader = factory.createFilteredReader(factory.createXMLEventReader(in), filter);
            if (reader.hasNext() && MAP.equals(reader.nextEvent().asStartElement().getName().getLocalPart())) {
                return this.parseReport(reader);
            }
            return null;
        }
        catch (XMLStreamException ex) {
            throw new GlassFishIdeException("Unable to parse XML Rest response.", ex);
        }
    }

    private RestActionReport parseReport(XMLEventReader reader) throws XMLStreamException {
        int level = 0;
        RestActionReport report = new RestActionReport();
        while (reader.hasNext() && level > -1) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && level++ == 0 && ENTRY.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) {
                HashMap<String, String> m = this.getMapEntry(element);
                String key = (String)m.get("key");
                String value = (String)m.get("value");
                if ("message".equals(key)) {
                    report.setMessage(value);
                } else if ("exit_code".equals(key)) {
                    report.setExitCode(ActionReport.ExitCode.valueOf(value));
                } else if ("command".equals(key)) {
                    report.setActionDescription(value);
                } else if ("children".equals(key)) {
                    report.topMessagePart.children = this.parseChildrenMessages(reader);
                    --level;
                } else if ("subReports".equals(key)) {
                    report.subActions = this.parseSubReports(reader);
                }
            }
            if (!event.isEndElement()) continue;
            --level;
        }
        return report;
    }

    private HashMap<String, String> getMapEntry(StartElement entry) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        Iterator<Attribute> iter = entry.getAttributes();
        while (iter.hasNext()) {
            Attribute att = iter.next();
            entryMap.put(att.getName().getLocalPart(), att.getValue());
        }
        return entryMap;
    }

    private List<MessagePart> parseChildrenMessages(XMLEventReader reader) throws XMLStreamException {
        ArrayList<MessagePart> messages = new ArrayList<MessagePart>();
        int level = 0;
        while (reader.hasNext() && level > -1) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement element;
                String elementName;
                if (level++ != 1 || !MAP.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
                messages.add(this.parseChildMessage(reader));
                --level;
                continue;
            }
            --level;
        }
        return messages;
    }

    private MessagePart parseChildMessage(XMLEventReader reader) throws XMLStreamException {
        MessagePart msg = new MessagePart();
        int level = 0;
        while (reader.hasNext() && level > -1) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement element;
                String elementName;
                if (level++ != 0 || !ENTRY.equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
                HashMap<String, String> m = this.getMapEntry(element);
                String key = (String)m.get("key");
                String value = (String)m.get("value");
                if ("message".equals(key)) {
                    msg.setMessage(value);
                    continue;
                }
                if ("properties".equals(key)) {
                    msg.props = this.parseProperties(reader);
                    continue;
                }
                if (!"children".equals(key)) continue;
                msg.children = this.parseChildrenMessages(reader);
                continue;
            }
            --level;
        }
        return msg;
    }

    private Properties parseProperties(XMLEventReader reader) {
        Properties props = new Properties();
        return props;
    }

    private List<? extends ActionReport> parseSubReports(XMLEventReader reader) {
        ArrayList subReports = new ArrayList();
        return subReports;
    }

    private static class RestXMLResponseFilter
    implements EventFilter {
        private RestXMLResponseFilter() {
        }

        @Override
        public boolean accept(XMLEvent event) {
            return event.isStartElement() || event.isEndElement();
        }
    }
}

