/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Properties;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.response.ActionReport;
import org.glassfish.tools.ide.admin.response.MessagePart;
import org.glassfish.tools.ide.admin.response.RestActionReport;
import org.glassfish.tools.ide.admin.response.RestResponseParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class RestJSONResponseParser
extends RestResponseParser {
    @Override
    public RestActionReport parse(InputStream in) {
        RestActionReport report = new RestActionReport();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            RestJSONResponseParser.copy(in, out);
            String respMsg = out.toString("UTF-8");
            JSONObject json = (JSONObject)JSONValue.parseWithException((String)respMsg);
            this.parseReport(report, json);
        }
        catch (IOException ex) {
            throw new GlassFishIdeException("Unable to copy JSON response.", ex);
        }
        catch (ParseException e) {
            throw new GlassFishIdeException("Unable to parse JSON response.", e);
        }
        return report;
    }

    private void parseReport(RestActionReport report, JSONObject json) {
        report.setExitCode(ActionReport.ExitCode.valueOf((String)json.get((Object)"exit_code")));
        report.setActionDescription((String)json.get((Object)"command"));
        report.topMessagePart = this.parseMessagePart(json);
    }

    private MessagePart parseMessagePart(JSONObject json) {
        MessagePart mp = new MessagePart();
        mp.setMessage((String)json.get((Object)"message"));
        mp.setProperties(this.parseProperties(json));
        JSONArray children = (JSONArray)json.get((Object)"children");
        if (children != null) {
            mp.children = new ArrayList<MessagePart>(children.size());
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = (JSONObject)children.get(i);
                mp.children.add(this.parseMessagePart(child));
            }
        }
        return mp;
    }

    private Properties parseProperties(JSONObject json) {
        Properties result = new Properties();
        JSONObject properties = (JSONObject)json.get((Object)"properties");
        if (properties != null) {
            for (Object key : properties.keySet()) {
                String value = (String)properties.get(key);
                result.setProperty((String)key, value);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int read;
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(out);
            ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
            do {
                if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.rewind();
                outChannel.write(byteBuffer);
                byteBuffer.clear();
            } while (read != -1);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

