/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin.response;

import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.response.ResponseContentType;
import org.glassfish.tools.ide.admin.response.RestJSONResponseParser;
import org.glassfish.tools.ide.admin.response.RestResponseParser;
import org.glassfish.tools.ide.admin.response.RestXMLResponseParser;

public class ResponseParserFactory {
    private static RestXMLResponseParser xmlParser;
    private static RestJSONResponseParser jsonParser;

    public static synchronized RestResponseParser getRestParser(ResponseContentType contentType) {
        switch (contentType) {
            case APPLICATION_XML: {
                if (xmlParser == null) {
                    xmlParser = new RestXMLResponseParser();
                }
                return xmlParser;
            }
            case APPLICATION_JSON: {
                if (jsonParser == null) {
                    jsonParser = new RestJSONResponseParser();
                }
                return jsonParser;
            }
            case TEXT_PLAIN: {
                return null;
            }
        }
        throw new GlassFishIdeException("Not supported content type. Cannot create response parser!");
    }
}

