/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.util.HashMap;
import java.util.Map;

public enum TaskEvent {
    SUBMIT,
    START,
    EXCEPTION,
    CMD_RUNNING,
    CMD_EXCEPTION,
    CMD_COMPLETED,
    CMD_FAILED,
    LOCAL_AUTH_FAILED,
    REMOTE_AUTH_FAILED,
    EMPTY_MESSAGE,
    NO_JAVA_VM,
    WRONG_JAVA_VM,
    JAVA_VM_EXEC_FAILED;

    private static final String SUBMIT_STR = "Submit";
    private static final String START_STR = "Start";
    private static final String EXCEPTION_STR = "Exception";
    private static final String CMD_RUNNING_STR = "CmdRunning";
    private static final String CMD_EXCEPTION_STR = "CmdException";
    private static final String CMD_COMPLETED_STR = "CmdCompleted";
    private static final String CMD_FAILED_STR = "CmdFailed";
    private static final String LOCAL_AUTH_FAILED_STR = "LocalAuthFailed";
    private static final String REMOTE_AUTH_FAILED_STR = "RemoteAuthFailed";
    private static final String EMPTY_MESSAGE_STR = "EmptyMessage";
    private static final String NO_JAVA_VM_STR = "NoJavaVm";
    private static final String WRONG_JAVA_VM_STR = "WrongJavaVm";
    private static final String JAVA_VM_EXEC_FAILED_STR = "JavaVmExecFailed";
    private static final Map<String, TaskEvent> stringValuesMap;

    public static TaskEvent toValue(String eventStr) {
        if (eventStr != null) {
            return stringValuesMap.get(eventStr.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case SUBMIT: {
                return SUBMIT_STR;
            }
            case START: {
                return START_STR;
            }
            case EXCEPTION: {
                return EXCEPTION_STR;
            }
            case CMD_RUNNING: {
                return CMD_RUNNING_STR;
            }
            case CMD_EXCEPTION: {
                return CMD_EXCEPTION_STR;
            }
            case CMD_COMPLETED: {
                return CMD_COMPLETED_STR;
            }
            case CMD_FAILED: {
                return CMD_FAILED_STR;
            }
            case LOCAL_AUTH_FAILED: {
                return LOCAL_AUTH_FAILED_STR;
            }
            case REMOTE_AUTH_FAILED: {
                return REMOTE_AUTH_FAILED_STR;
            }
            case EMPTY_MESSAGE: {
                return EMPTY_MESSAGE_STR;
            }
            case NO_JAVA_VM: {
                return NO_JAVA_VM_STR;
            }
            case WRONG_JAVA_VM: {
                return WRONG_JAVA_VM_STR;
            }
            case JAVA_VM_EXEC_FAILED: {
                return JAVA_VM_EXEC_FAILED_STR;
            }
        }
        return null;
    }

    static {
        stringValuesMap = new HashMap<String, TaskEvent>(TaskEvent.values().length);
        for (TaskEvent state : TaskEvent.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
    }
}

