/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.glassfish.tools.ide.admin.AdminFactory;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.Runner;
import org.glassfish.tools.ide.admin.TaskStateListener;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;

public class ServerAdmin {
    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd, ide);
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd, ide);
        runner.stateListener = listeners;
        return runner.execute();
    }

    public static ExecutorService executor(int size) {
        return Runner.parallelExecutor(size);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd, ide);
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd, ide);
        runner.stateListener = listeners;
        return runner.execute(executor);
    }
}

