/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandGetProperty;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.RunnerRest;
import org.glassfish.tools.ide.admin.response.MessagePart;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;

public class RunnerRestGetProperty
extends RunnerRest {
    ResultMap<String, String> result;

    public RunnerRestGetProperty(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, "/command/", null);
    }

    @Override
    protected ResultMap<String, String> createResult() {
        this.result = new ResultMap<String, String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        List<MessagePart> childMessages = this.report.getTopMessagePart().getChildren();
        if (childMessages == null || childMessages.isEmpty()) {
            return false;
        }
        this.result.value = new HashMap(childMessages.size());
        for (MessagePart msg : childMessages) {
            String message = msg.getMessage();
            int equalsIndex = message.indexOf(61);
            if (equalsIndex >= 0) {
                String keyPart = message.substring(0, equalsIndex);
                String valuePart = message.substring(equalsIndex + 1);
                Level logLevel = Level.WARNING;
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    logLevel = Level.FINE;
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.log(Level.WARNING, "UnsupportedEncodingException for value \"{0}\"", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException iae) {
                    Logger.log(logLevel, "IllegalArgumentException for value \"{0}\" : inserted into propertyMap as \"{1}\"", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            Logger.log(Level.WARNING, "Inserting empty string as value for key=\"{0}\"", message);
            this.result.value.put(message, "");
        }
        return true;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(hconn.getOutputStream());
        CommandGetProperty gpCommand = (CommandGetProperty)this.command;
        StringBuilder data = new StringBuilder();
        data.append("pattern=").append(gpCommand.propertyPattern);
        wr.write(data.toString());
        wr.flush();
        wr.close();
    }
}

