/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.CommandFetchLogData;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.ResultLog;
import org.glassfish.tools.ide.admin.RunnerRest;
import org.glassfish.tools.ide.admin.ValueLog;
import org.glassfish.tools.ide.admin.response.ResponseContentType;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;

public class RunnerRestFetchLogData
extends RunnerRest {
    private List<String> lines;
    private URL headerAppendNext;
    ResultLog result;

    private static String query(Command command) {
        if (command instanceof CommandFetchLogData) {
            return ((CommandFetchLogData)command).paramsAppendNext;
        }
        throw new CommandException("Illegal command instance provided");
    }

    public RunnerRestFetchLogData(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, "/management/domain/", RunnerRestFetchLogData.query(command));
    }

    @Override
    protected Result createResult() {
        this.result = new ResultLog();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    protected String getRequestMethod() {
        return "GET";
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    public boolean readResponse(InputStream in, HttpURLConnection hconn) {
        this.lines = new LinkedList<String>();
        String ce = hconn.getContentEncoding();
        BufferedReader br = null;
        try {
            InputStream cooked = null != ce && ce.contains("gzip") ? new GZIPInputStream(in) : in;
            br = new BufferedReader(new InputStreamReader(cooked));
            while (br.ready()) {
                String line = br.readLine();
                if (line == null || line.length() <= 0) continue;
                this.lines.add(line);
            }
        }
        catch (IOException ioe) {
            throw new CommandException("Can not read HTTP response, caught IOException", ioe);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
            }
        }
        try {
            this.headerAppendNext = new URL(hconn.getHeaderField("X-Text-Append-Next"));
        }
        catch (MalformedURLException mue) {
            Logger.log(Level.WARNING, mue.getLocalizedMessage(), mue);
            this.headerAppendNext = null;
            return false;
        }
        String queryAppendNext = this.headerAppendNext.getQuery();
        return queryAppendNext != null;
    }

    @Override
    protected boolean processResponse() {
        ArrayList<String> logLines = new ArrayList<String>(this.lines.size());
        for (String line : this.lines) {
            logLines.add(line);
        }
        this.result.value = new ValueLog(logLines, this.headerAppendNext.getQuery());
        return true;
    }

    @Override
    protected ResponseContentType getResponseType() {
        return ResponseContentType.TEXT_PLAIN;
    }
}

