/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import org.glassfish.tools.ide.GlassFishIdeException;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandDeploy;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.RunnerRest;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;

public class RunnerRestDeploy
extends RunnerRest {
    private static final String NEWLINE = "\r\n";
    private String multipartBoundary = Long.toHexString(System.currentTimeMillis());
    final CommandDeploy command;

    public RunnerRestDeploy(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide);
        this.command = (CommandDeploy)command;
    }

    @Override
    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        super.prepareHttpConnection(conn);
        if (!this.command.dirDeploy) {
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.multipartBoundary);
        }
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        if (this.command.path == null) {
            throw new GlassFishIdeException("The path attribute of deploy command has to be non-empty!");
        }
        OutputStreamWriter wr = new OutputStreamWriter(hconn.getOutputStream());
        if (!this.command.dirDeploy) {
            this.writeParam(wr, "path", this.command.path.toString());
            if (this.command.name != null) {
                this.writeParam(wr, "name", this.command.name);
            }
            if (this.command.contextRoot != null) {
                this.writeParam(wr, "contextroot", this.command.contextRoot);
            }
            if (this.command.target != null) {
                this.writeParam(wr, "target", this.command.target);
            }
            this.writeBinaryFile(wr, hconn.getOutputStream(), this.command.path);
            wr.append("--" + this.multipartBoundary + "--").append(NEWLINE);
        } else {
            wr.write("path=" + this.command.path.toString());
            if (this.command.name != null) {
                wr.write("&");
                wr.write("name=" + this.command.name);
            }
            if (this.command.contextRoot != null) {
                wr.write("&");
                wr.write("contextroot=" + this.command.name);
            }
            if (this.command.target != null) {
                wr.write("&");
                wr.write("target=" + this.command.target);
            }
        }
        wr.close();
    }

    private void writeParam(OutputStreamWriter writer, String paramName, String paramValue) throws IOException {
        writer.append("--" + this.multipartBoundary).append(NEWLINE);
        writer.append("Content-Disposition: form-data; name=\"").append(paramName).append("\"").append(NEWLINE);
        writer.append("Content-Type: text/plain;").append(NEWLINE);
        writer.append(NEWLINE);
        writer.append(paramValue).append(NEWLINE).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBinaryFile(OutputStreamWriter writer, OutputStream output, File file) throws IOException {
        writer.append("--" + this.multipartBoundary).append(NEWLINE);
        writer.append("Content-Disposition: form-data; name=\"warFile\"; filename=\"" + file.getAbsolutePath() + "\"").append(NEWLINE);
        writer.append("Content-Type: application/octet-stream").append(NEWLINE);
        writer.append("Content-Transfer-Encoding: binary").append(NEWLINE);
        writer.append(NEWLINE).flush();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] buffer = new byte[0x100000];
            int length = 0;
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            output.flush();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {}
            }
        }
        writer.append(NEWLINE).flush();
    }

    @Override
    public String getContentType() {
        return this.command.dirDeploy ? null : "application/zip";
    }

    public InputStream getInputStream() {
        if (this.command.dirDeploy) {
            return null;
        }
        try {
            return new FileInputStream(this.command.path);
        }
        catch (FileNotFoundException fnfe) {
            Logger.log(Level.INFO, this.command.path.getPath(), fnfe);
            return null;
        }
    }
}

