/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.Runner;
import org.glassfish.tools.ide.admin.response.ResponseContentType;
import org.glassfish.tools.ide.admin.response.ResponseParserFactory;
import org.glassfish.tools.ide.admin.response.RestActionReport;
import org.glassfish.tools.ide.admin.response.RestResponseParser;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.utils.ServerUtils;

public class RunnerRest
extends Runner {
    RestResponseParser parser = ResponseParserFactory.getRestParser(this.getResponseType());
    RestActionReport report;
    protected ResultString result;

    public RunnerRest(GlassFishServer server, Command command, IdeContext ide) {
        this(server, command, ide, null);
    }

    public RunnerRest(GlassFishServer server, Command command, IdeContext ide, String query) {
        this(server, command, ide, "/command/", query);
    }

    public RunnerRest(GlassFishServer server, Command command, IdeContext ide, String path, String query) {
        super(server, command, ide, path, query);
        this.silentFailureAllowed = false;
    }

    @Override
    protected Result createResult() {
        this.result = new ResultString();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return true;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        URI uri;
        String protocol = "http";
        try {
            uri = new URI(protocol, null, this.server.getHost(), this.server.getAdminPort(), this.path + this.command.getCommand(), this.query, null);
        }
        catch (URISyntaxException use) {
            throw new CommandException("Cannot build HTTP command URL", use);
        }
        return uri.toASCIIString();
    }

    @Override
    protected String getRequestMethod() {
        return "GET";
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        this.report = this.parser.parse(in);
        return this.report.isSuccess();
    }

    @Override
    protected boolean processResponse() {
        this.result.value = this.report.getMessage();
        return this.report.isSuccess();
    }

    @Override
    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        super.prepareHttpConnection(conn);
        String adminUser = this.server.getAdminUser();
        String adminPassword = this.server.getAdminPassword();
        if (adminUser != null && adminUser.length() > 0) {
            adminPassword = adminPassword != null && adminPassword.length() > 0 ? adminPassword : "";
            String auth = ServerUtils.basicAuthCredentials(adminUser, adminPassword);
            conn.setRequestProperty("Authorization", "Basic " + auth);
        }
        conn.setRequestProperty("Accept", this.getResponseType().toString());
        conn.addRequestProperty("X-Requested-By", "GlassFish REST HTML interface");
    }

    protected ResponseContentType getResponseType() {
        return ResponseContentType.APPLICATION_JSON;
    }
}

