/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.CommandStartDAS;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.ResultProcess;
import org.glassfish.tools.ide.admin.Runner;
import org.glassfish.tools.ide.admin.TaskEvent;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.admin.ValueProcess;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.JavaUtils;
import org.glassfish.tools.ide.utils.OsUtils;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.glassfish.tools.ide.utils.Utils;

public class RunnerLocal
extends Runner {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    final CommandStartDAS command;
    private String arguments;
    ResultProcess result;

    public RunnerLocal(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, null, null);
        this.command = (CommandStartDAS)command;
    }

    @Override
    protected Result createResult() {
        this.result = new ResultProcess();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        return null;
    }

    @Override
    protected String getRequestMethod() {
        return null;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        return false;
    }

    @Override
    protected boolean processResponse() {
        return false;
    }

    private static String buildJavaOptions(GlassFishServer server, CommandStartDAS command) {
        boolean isOptions;
        StringBuilder sb = new StringBuilder();
        boolean isClasspath = command.classpath != null && command.classpath.length() > 0;
        boolean bl = isOptions = command.javaOpts != null && command.javaOpts.length() > 0;
        if (isClasspath) {
            sb.append("-cp ");
            sb.append(command.classpath);
            sb.append(" ");
        }
        sb.append(ServerUtils.javaRootProperty(command.javaHome));
        sb.append(" ");
        if (isOptions) {
            sb.append(command.javaOpts);
            sb.append(" ");
        }
        if (isClasspath) {
            sb.append(MAIN_CLASS);
            sb.append(" ");
        } else {
            File bootstrapJar = ServerUtils.getJarName(server.getServerHome(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            sb.append(" -jar ");
            sb.append(Utils.quote(bootstrapJar.getAbsolutePath()));
            sb.append(" ");
        }
        if (command.glassfishArgs != null && command.glassfishArgs.length() > 0) {
            sb.append(command.glassfishArgs);
        }
        return sb.toString();
    }

    private static void setJavaEnvironment(Map<String, String> env, CommandStartDAS command) {
        env.put("JAVA_HOME", command.javaHome);
        env.put("AS_JAVA", command.javaHome);
    }

    @Override
    public Result call() {
        Process process;
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(this.command.javaHome);
        File javaVmFile = new File(javaVmExe);
        if (!javaVmFile.exists()) {
            Logger.log(Level.INFO, "Java VM {0} executable for {1} was not found", new Object[]{javaVmFile.getAbsolutePath(), this.server.getName()});
            return this.handleStateChange(TaskState.FAILED, TaskEvent.NO_JAVA_VM, this.command.getCommand(), this.server.getName());
        }
        JavaUtils.JavaVersion javaVersion = JavaUtils.javaVmVersion(javaVmFile);
        Logger.log(Level.FINEST, "Java VM {0} executable version {1}", new Object[]{javaVmFile.getAbsolutePath(), javaVersion != null ? javaVersion.toString() : "null"});
        if (javaVersion == null || javaVersion.comapreTo(new JavaUtils.JavaVersion(1, 6, 0, 0)) == -1) {
            Logger.log(Level.INFO, "Java VM {0} executable version {1} can't be used with {2} but trying to start server anyway.", new Object[]{javaVmFile.getAbsolutePath(), javaVersion != null ? javaVersion.toString() : "null", this.server.getName()});
        }
        String allArgs = RunnerLocal.buildJavaOptions(this.server, this.command);
        String[] args = OsUtils.parseParameters(javaVmExe, allArgs);
        Logger.log(Level.FINEST, "Starting {0} using Java VM {1} and arguments {2}", new Object[]{this.server.getName(), javaVmExe, allArgs});
        ProcessBuilder pb = new ProcessBuilder(args);
        RunnerLocal.setJavaEnvironment(pb.environment(), this.command);
        try {
            process = pb.start();
        }
        catch (IOException ex) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.JAVA_VM_EXEC_FAILED, this.command.getCommand(), this.server.getName());
        }
        this.result.value = new ValueProcess(javaVmFile.getAbsolutePath(), allArgs, process);
        return this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.command.getCommand(), this.server.getName());
    }
}

