/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.ResultList;
import org.glassfish.tools.ide.admin.RunnerHttpTarget;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;

public class RunnerHttpListResources
extends RunnerHttpTarget {
    ResultList<String> result;

    public RunnerHttpListResources(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide);
    }

    @Override
    protected ResultList<String> createResult() {
        this.result = new ResultList<String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        String resourcesAttr = this.manifest.getMainAttributes().getValue("children");
        String[] resources = resourcesAttr != null ? resourcesAttr.split("[,;]") : null;
        int resoucesCount = resources != null ? resources.length : 0;
        this.result.value = new ArrayList(resoucesCount);
        for (String resource : resources) {
            String name;
            Attributes resourceAttr = this.manifest.getAttributes(resource);
            String resourceMsg = resourceAttr.getValue("message");
            try {
                name = resourceMsg != null ? URLDecoder.decode(resourceMsg, "UTF-8") : null;
                if (name == null || name.length() <= 0) {
                    name = URLDecoder.decode(resource.trim(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                throw new CommandException("Can not read HTTP response, caught UnsupportedEncodingException", uee);
            }
            this.result.value.add(name);
        }
        return true;
    }
}

