/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandGetProperty;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.ResultMap;
import org.glassfish.tools.ide.admin.RunnerHttp;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;

public class RunnerHttpGetProperty
extends RunnerHttp {
    ResultMap<String, String> result;

    public RunnerHttpGetProperty(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, "pattern=" + ((CommandGetProperty)command).propertyPattern);
    }

    @Override
    protected Result createResult() {
        this.result = new ResultMap();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        if (this.manifest == null) {
            Logger.log(Level.WARNING, "info is null for GetProperty command with \"{0}\"", this.query);
            return false;
        }
        this.result.value = new HashMap();
        for (String encodedkey : this.manifest.getEntries().keySet()) {
            String key = "";
            try {
                if (null != encodedkey) {
                    key = encodedkey;
                    key = URLDecoder.decode(encodedkey, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                Logger.log(Level.INFO, encodedkey, uee);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            int equalsIndex = key.indexOf(61);
            if (equalsIndex >= 0) {
                String keyPart = key.substring(0, equalsIndex);
                String valuePart = key.substring(equalsIndex + 1);
                Level logLevel = Level.WARNING;
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    logLevel = Level.FINE;
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.log(Level.WARNING, "UnsupportedEncodingException for value \"{0}\"", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException iae) {
                    Logger.log(logLevel, "IllegalArgumentException for value \"{0}\" : inserted into propertyMap as \"{1}\"", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            Logger.log(Level.WARNING, "Inserting empty string as value for key=\"{0}\"", key);
            this.result.value.put(key, "");
        }
        return true;
    }
}

