/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandDeploy;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.RunnerHttp;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.Utils;

public class RunnerHttpDeploy
extends RunnerHttp {
    private static final String DEFAULT_PARAM = "DEFAULT";
    private static final String TARGET_PARAM = "target";
    private static final String NAME_PARAM = "name";
    private static final String CTXROOT_PARAM = "contextroot";
    private static final String FORCE_PARAM = "force";
    private static final String PROPERTIES_PARAM = "properties";
    private static final boolean FORCE_VALUE = true;
    final CommandDeploy command;

    private static int queryPropertiesLength(Map<String, String> properties, String paramName) {
        int propertyLength = 0;
        if (null != properties && properties.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = properties.entrySet();
            boolean first = true;
            propertyLength += paramName.length() + 1;
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (key == null) {
                    throw new CommandException("Value shall not be null");
                }
                if (first) {
                    first = false;
                } else {
                    ++propertyLength;
                }
                propertyLength += key.length() + 1 + (val != null ? val.length() : 0);
            }
        }
        return propertyLength;
    }

    private static StringBuilder queryPropertiesAppend(StringBuilder sb, Map<String, String> properties, String paramName) {
        if (null != properties && properties.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = properties.entrySet();
            boolean first = true;
            sb.append('&');
            sb.append(paramName).append('=');
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (first) {
                    first = false;
                } else {
                    sb.append(':');
                }
                sb.append(key);
                sb.append('=');
                if (val == null) continue;
                sb.append(val);
            }
        }
        return sb;
    }

    private static String query(Command command) {
        String force = Boolean.toString(true);
        if (command instanceof CommandDeploy) {
            if (((CommandDeploy)command).path == null) {
                throw new CommandException("Value shall not be null");
            }
        } else {
            throw new CommandException("Illegal command instance provided");
        }
        String path = ((CommandDeploy)command).path.getAbsolutePath();
        String target = Utils.sanitizeName(((CommandDeploy)command).target);
        String name = Utils.sanitizeName(((CommandDeploy)command).name);
        String ctxRoot = Utils.sanitizeName(((CommandDeploy)command).contextRoot);
        StringBuilder sb = new StringBuilder(DEFAULT_PARAM.length() + 1 + path.length() + 1 + FORCE_PARAM.length() + 1 + force.length() + 1 + RunnerHttpDeploy.queryPropertiesLength(((CommandDeploy)command).properties, PROPERTIES_PARAM) + (name != null && name.length() > 0 ? 1 + NAME_PARAM.length() + 1 + name.length() : 0) + (target != null ? 1 + TARGET_PARAM.length() + 1 + target.length() : 0) + (ctxRoot != null && ctxRoot.length() > 0 ? 1 + CTXROOT_PARAM.length() + 1 + ctxRoot.length() : 0));
        sb.append(DEFAULT_PARAM).append('=').append(path);
        sb.append('&');
        sb.append(FORCE_PARAM).append('=').append(force);
        if (name != null && name.length() > 0) {
            sb.append('&');
            sb.append(NAME_PARAM).append('=').append(name);
        }
        if (target != null) {
            sb.append('&');
            sb.append(TARGET_PARAM).append('=').append(target);
        }
        if (ctxRoot != null && ctxRoot.length() > 0) {
            sb.append('&');
            sb.append(CTXROOT_PARAM).append('=').append(ctxRoot);
        }
        RunnerHttpDeploy.queryPropertiesAppend(sb, ((CommandDeploy)command).properties, PROPERTIES_PARAM);
        return sb.toString();
    }

    public RunnerHttpDeploy(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, RunnerHttpDeploy.query(command));
        this.command = (CommandDeploy)command;
    }

    @Override
    public boolean getDoOutput() {
        return !this.command.dirDeploy;
    }

    @Override
    public String getRequestMethod() {
        return this.command.dirDeploy ? super.getRequestMethod() : "POST";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        InputStream istream = this.getInputStream();
        if (istream != null) {
            ZipOutputStream ostream = null;
            try {
                int n;
                ostream = new ZipOutputStream(new BufferedOutputStream(hconn.getOutputStream(), 0x100000));
                ZipEntry e = new ZipEntry(this.command.path.getName());
                e.setExtra(this.getExtraProperties());
                ostream.putNextEntry(e);
                byte[] buffer = new byte[0x100000];
                while ((n = istream.read(buffer)) >= 0) {
                    ostream.write(buffer, 0, n);
                }
                ostream.closeEntry();
                ostream.flush();
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    Logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException ex) {
                        Logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
            }
        }
        if ("POST".equalsIgnoreCase(this.getRequestMethod())) {
            Logger.log(Level.INFO, "HTTP POST request but no data stream provided");
        }
    }

    @Override
    public String getContentType() {
        return this.command.dirDeploy ? null : "application/zip";
    }

    @Override
    public String getLastModified() {
        return Long.toString(this.command.path.lastModified());
    }

    public InputStream getInputStream() {
        if (this.command.dirDeploy) {
            return null;
        }
        try {
            return new FileInputStream(this.command.path);
        }
        catch (FileNotFoundException fnfe) {
            Logger.log(Level.INFO, this.command.path.getPath(), fnfe);
            return null;
        }
    }
}

