/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.util.logging.Level;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandCreateInstance;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.CommandTargetName;
import org.glassfish.tools.ide.admin.RunnerHttp;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.Utils;

public class RunnerHttpCreateInstance
extends RunnerHttp {
    private static final String DEFAULT_PARAM = "DEFAULT";
    private static final String NODE_PARAM = "node";
    private static final String CLUSTER_PARAM = "cluster";

    private static String query(Command command) {
        String cluster;
        if (command instanceof CommandCreateInstance) {
            cluster = Utils.sanitizeName(((CommandCreateInstance)command).target);
            if (((CommandTargetName)command).name == null || ((CommandCreateInstance)command).node == null) {
                throw new CommandException("Value shall not be null");
            }
        } else {
            throw new CommandException("Illegal command instance provided");
        }
        String name = Utils.sanitizeName(((CommandCreateInstance)command).name);
        String node = Utils.sanitizeName(((CommandCreateInstance)command).node);
        StringBuilder sb = new StringBuilder(DEFAULT_PARAM.length() + 1 + name.length() + 1 + NODE_PARAM.length() + 1 + node.length() + (cluster != null ? 1 + CLUSTER_PARAM.length() + 1 + cluster.length() : 0));
        sb.append(DEFAULT_PARAM).append('=').append(name);
        sb.append('&');
        sb.append(NODE_PARAM).append('=').append(node);
        if (cluster != null) {
            sb.append('&');
            sb.append(CLUSTER_PARAM).append('=').append(cluster);
        }
        return sb.toString();
    }

    public RunnerHttpCreateInstance(GlassFishServer server, Command command, IdeContext ide) {
        super(server, command, ide, RunnerHttpCreateInstance.query(command));
    }

    @Override
    protected boolean processResponse() {
        try {
            this.result.value = this.manifest.getMainAttributes().getValue("message");
            this.result.value = this.result.value.replace("%%%EOL%%%", "\n");
        }
        catch (IllegalArgumentException iae) {
            Logger.log(Level.WARNING, "Caught IllegalArgumentException", iae);
        }
        return this.result.value != null;
    }
}

