/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.ResultString;
import org.glassfish.tools.ide.admin.Runner;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.ServerUtils;
import org.glassfish.tools.ide.utils.Utils;

public class RunnerHttp
extends Runner {
    Manifest manifest;
    ResultString result;

    private static boolean successExitCode(Manifest manifest) {
        String exitCode = manifest.getMainAttributes().getValue("exit-code");
        return exitCode == null || !"FAILURE".equals(exitCode.toUpperCase(Locale.ENGLISH));
    }

    private static String getHttpListenerProtocol(String hostname, int port, String url) {
        String retVal = "http";
        try {
            if (Utils.isSecurePort(hostname, port)) {
                retVal = "https";
            }
        }
        catch (ConnectException ex) {
            Logger.log(Level.INFO, hostname + ":" + port + "::" + url, ex);
        }
        catch (SocketException ex) {
            Logger.log(Level.FINE, hostname + ":" + port + "::" + url, ex);
        }
        catch (SocketTimeoutException ex) {
            Logger.log(Level.INFO, hostname + ":" + port + "::" + url, ex);
        }
        catch (IOException ex) {
            Logger.log(Level.INFO, hostname + ":" + port + "::" + url, ex);
        }
        return retVal;
    }

    public RunnerHttp(GlassFishServer server, Command command, IdeContext ide) {
        this(server, command, ide, null);
    }

    RunnerHttp(GlassFishServer server, Command command, IdeContext ide, String query) {
        this(server, command, ide, "/__asadmin/", query);
    }

    protected RunnerHttp(GlassFishServer server, Command command, IdeContext ide, String path, String query) {
        super(server, command, ide, path, query);
        this.silentFailureAllowed = false;
    }

    @Override
    protected Result createResult() {
        this.result = new ResultString();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        URI uri;
        String host = this.server.getHost();
        boolean useAdminPort = !"false".equals(System.getProperty("glassfish.useadminport"));
        int port = useAdminPort ? this.server.getAdminPort() : this.server.getPort();
        String protocol = "http";
        String url = this.server.getUrl();
        String domainsDir = this.server.getDomainsFolder();
        if (null == url) {
            protocol = RunnerHttp.getHttpListenerProtocol(host, port, ":::" + this.command.getCommand() + "?" + this.query);
        } else if (!url.contains("ee6wc")) {
            protocol = RunnerHttp.getHttpListenerProtocol(host, port, url + ":::" + this.command.getCommand() + "?" + this.query);
        } else if (url.contains("ee6wc") && (null == domainsDir || "".equals(domainsDir))) {
            protocol = "https";
        }
        try {
            uri = new URI(protocol, null, host, port, this.path + this.command.getCommand(), this.query, null);
        }
        catch (URISyntaxException use) {
            throw new CommandException("Cannot build HTTP command URL", use);
        }
        return uri.toASCIIString().replace("+", "%2b");
    }

    @Override
    protected String getRequestMethod() {
        return "GET";
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        boolean readResult;
        this.manifest = new Manifest();
        try {
            Logger.log(Level.FINEST, "Reading response from {0}:{1}", new Object[]{this.server.getHost(), Integer.toString(this.server.getAdminPort())});
            this.manifest.read(in);
        }
        catch (IOException ioe) {
            throw new CommandException("Can not read HTTP response, caught IOException", ioe);
        }
        if (RunnerHttp.successExitCode(this.manifest)) {
            readResult = true;
        } else {
            readResult = false;
            String message = this.getMessage(this.manifest);
            if (message != null && message.contains("please wait")) {
                this.retry = true;
            }
        }
        return readResult;
    }

    @Override
    protected boolean processResponse() {
        this.result.value = this.getMessage(this.manifest);
        Logger.log(Level.FINEST, "Manifest message: {0}", new Object[]{this.result.value});
        return this.result.value != null;
    }

    public String getLastModified() {
        return null;
    }

    private String getMessage(Manifest manifest) {
        String message = null;
        String tmp = manifest.getMainAttributes().getValue("message");
        if (null != tmp) {
            try {
                message = URLDecoder.decode(ServerUtils.manifestDecode(tmp), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                Logger.log(Level.WARNING, "Could not URL decode with UTF-8", uee);
            }
            catch (IllegalArgumentException iae) {
                Logger.log(Level.FINE, "Caught IllegalArgumentException", iae);
                message = tmp;
            }
        }
        return message;
    }

    byte[] getExtraProperties() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = new Properties();
        props.setProperty("data-request-type", "file-xfer");
        props.setProperty("last-modified", this.getLastModified());
        props.put("data-request-name", "DEFAULT");
        props.put("data-request-is-recursive", "true");
        props.put("Content-Type", "application/octet-stream");
        props.list(new PrintStream(baos));
        return baos.toByteArray();
    }

    @Override
    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        super.prepareHttpConnection(conn);
        String contentType = this.getContentType();
        if (contentType == null || contentType.length() <= 0) {
            conn.setRequestProperty("Content-Type", "image/png");
        }
        conn.setRequestProperty("User-Agent", "hk2-agent");
    }
}

