/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.Result;
import org.glassfish.tools.ide.admin.TaskEvent;
import org.glassfish.tools.ide.admin.TaskState;
import org.glassfish.tools.ide.admin.TaskStateListener;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.IdeContext;
import org.glassfish.tools.ide.logging.Logger;
import org.glassfish.tools.ide.utils.ServerUtils;

abstract class Runner
implements Callable<Result> {
    public static final int HTTP_CONNECTION_TIMEOUT = 3000;
    public static final int HTTP_RETRY_DELAY = 3000;
    static final char QUERY_SEPARATOR = '?';
    static final char PARAM_SEPARATOR = '&';
    static final char ITEM_SEPARATOR = ':';
    static final char PARAM_ASSIGN_VALUE = '=';
    private static volatile ExecutorService executor;
    protected boolean silentFailureAllowed = false;
    protected String path;
    boolean retry = false;
    protected GlassFishServer server;
    final Command command;
    Result result;
    IdeContext ide;
    final String query;
    protected TaskStateListener[] stateListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExecutorService serializedExecutor() {
        if (executor != null) {
            return executor;
        }
        Class<Runner> clazz = Runner.class;
        synchronized (Runner.class) {
            if (executor == null) {
                executor = Executors.newFixedThreadPool(1);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executor;
        }
    }

    static ExecutorService parallelExecutor(int size) {
        return Executors.newFixedThreadPool(size);
    }

    protected abstract Result createResult();

    public abstract boolean getDoOutput();

    public abstract boolean acceptsGzip();

    protected abstract String constructCommandUrl() throws CommandException;

    protected abstract String getRequestMethod();

    protected abstract void handleSend(HttpURLConnection var1) throws IOException;

    protected abstract boolean readResponse(InputStream var1, HttpURLConnection var2);

    protected abstract boolean processResponse();

    Runner(GlassFishServer server, Command command, IdeContext ide, String path) {
        this(server, command, ide, path, null);
    }

    Runner(GlassFishServer server, Command command, IdeContext ide, String path, String query) {
        this.server = server;
        this.command = command;
        this.ide = ide;
        this.path = path;
        this.query = query;
    }

    String getQuery() {
        return this.query;
    }

    Command getCommand() {
        return this.command;
    }

    protected boolean isSilentFailureAllowed() {
        return this.silentFailureAllowed;
    }

    public void setSilentFailureAllowed(boolean silentFailureAllowed) {
        this.silentFailureAllowed = silentFailureAllowed;
    }

    public String getContentType() {
        return null;
    }

    String getCommandWithQuery() {
        String commandString = this.command.getCommand();
        if (this.query == null) {
            return commandString;
        }
        StringBuilder sb = new StringBuilder(commandString.length() + 1 + this.query.length());
        sb.append(commandString);
        sb.append('?');
        sb.append(this.query);
        return sb.toString();
    }

    String[] stateChangeArgs(String exMessage, boolean display) {
        return new String[]{this.server.getName(), this.command.getCommand(), exMessage, Boolean.toString(display)};
    }

    String[] stateChangeArgs(String exMessage) {
        return new String[]{this.server.getName(), this.command.getCommand(), exMessage, Boolean.toString(false)};
    }

    Result handleStateChange(TaskState newTaskState, TaskEvent taskEvent, String ... args) {
        this.result.state = newTaskState;
        if (this.stateListener != null) {
            for (int i = 0; i < this.stateListener.length; ++i) {
                if (this.stateListener[i] == null) continue;
                this.stateListener[i].operationStateChanged(newTaskState, taskEvent, args);
            }
        }
        return this.result;
    }

    Future<? extends Result> execute() {
        this.result = this.createResult();
        this.handleStateChange(TaskState.READY, TaskEvent.SUBMIT, this.stateChangeArgs(null));
        return Runner.serializedExecutor().submit(this);
    }

    Future<? extends Result> execute(ExecutorService executor) {
        this.result = this.createResult();
        this.handleStateChange(TaskState.READY, TaskEvent.SUBMIT, this.stateChangeArgs(null));
        return executor.submit(this);
    }

    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        conn.setAllowUserInteraction(false);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(3000);
        String adminUser = this.server.getAdminUser();
        String adminPassword = this.server.getAdminPassword();
        Logger.log(Level.FINEST, "Setting HTTP connection attributes: timeout = {0} user = {1} password = {2}", new Object[]{new Integer(3000), adminUser, adminPassword});
        try {
            conn.setRequestMethod(this.getRequestMethod());
        }
        catch (ProtocolException pe) {
            throw new CommandException("Cannos set headers for HTTP connection", pe);
        }
        conn.setDoOutput(this.getDoOutput());
        String contentType = this.getContentType();
        if (contentType != null && contentType.length() > 0) {
            conn.setRequestProperty("Content-Type", contentType);
            conn.setChunkedStreamingMode(0);
        }
        if (adminPassword != null && adminPassword.length() > 0) {
            String auth = ServerUtils.basicAuthCredentials(adminUser, adminPassword);
            Logger.log(Level.FINEST, "Using \"Basic\" authorization with user and password");
            conn.setRequestProperty("Authorization", "Basic " + auth);
        }
        if (this.acceptsGzip()) {
            conn.setRequestProperty("Accept-Encoding", "gzip");
        }
    }

    protected void handleSecureConnection(HttpsURLConnection conn) {
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, tm, null);
            conn.setSSLSocketFactory(context.getSocketFactory());
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            });
        }
        catch (Exception ex) {
            Logger.log(Level.INFO, "trust manager problem: " + conn.getURL(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleReceive(HttpURLConnection hconn) throws IOException {
        boolean receiveResult = false;
        InputStream httpInputStream = hconn.getInputStream();
        try {
            receiveResult = this.readResponse(httpInputStream, hconn);
        }
        finally {
            try {
                httpInputStream.close();
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
            }
        }
        return receiveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result call() {
        String commandUrl;
        String commandWithQuery = this.getCommandWithQuery();
        this.handleStateChange(TaskState.RUNNING, TaskEvent.CMD_RUNNING, this.stateChangeArgs(null));
        boolean httpSucceeded = false;
        boolean commandSucceeded = false;
        HttpURLConnection hconn = null;
        try {
            commandUrl = this.constructCommandUrl();
        }
        catch (CommandException ce) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_EXCEPTION, this.stateChangeArgs(ce.getLocalizedMessage()));
        }
        int retries = 1;
        Logger.log(Level.FINEST, "RunnerRest.call({0}) called on thread \"{1}\"", new Object[]{commandUrl, Thread.currentThread().getName()});
        try {
            URL urlToConnectTo = new URL(commandUrl);
            while (!httpSucceeded && retries-- > 0) {
                Result result;
                try {
                    Logger.log(Level.FINE, "HTTP Command: {0}", commandUrl);
                    URLConnection conn = urlToConnectTo.openConnection();
                    if (!(conn instanceof HttpURLConnection)) {
                        Logger.log(Level.INFO, "Unexpected connection type: {0}", urlToConnectTo);
                    } else {
                        URL oldUrlToConnectTo;
                        int respCode = 0;
                        do {
                            oldUrlToConnectTo = urlToConnectTo;
                            hconn = (HttpURLConnection)conn;
                            if (conn instanceof HttpsURLConnection) {
                                this.handleSecureConnection((HttpsURLConnection)hconn);
                            }
                            this.prepareHttpConnection(hconn);
                            Logger.log(Level.FINEST, "Connecting to {0}:{1}", new Object[]{this.server.getHost(), Integer.toString(this.server.getAdminPort())});
                            hconn.connect();
                            this.handleSend(hconn);
                            respCode = hconn.getResponseCode();
                            if (respCode == 401 || respCode == 403) {
                                if (this.server.getDomainsFolder() == null) {
                                    Result result2 = this.handleStateChange(TaskState.FAILED, TaskEvent.REMOTE_AUTH_FAILED, this.stateChangeArgs(null, true));
                                    return result2;
                                }
                                Result result3 = this.handleStateChange(TaskState.FAILED, TaskEvent.LOCAL_AUTH_FAILED, this.stateChangeArgs(null, true));
                                return result3;
                            }
                            if (respCode != 302 && respCode != 301) continue;
                            String newUrl = hconn.getHeaderField("Location");
                            if (null == newUrl || "".equals(newUrl.trim())) {
                                Logger.log(Level.SEVERE, "invalid redirect for {0}", urlToConnectTo.toString());
                                continue;
                            }
                            Logger.log(Level.FINE, "  moved to {0}", newUrl);
                            urlToConnectTo = new URL(newUrl);
                            conn = urlToConnectTo.openConnection();
                            hconn.disconnect();
                        } while (urlToConnectTo != oldUrlToConnectTo);
                        if (Boolean.getBoolean("org.netbeans.modules.hk2.LogManagerCommands")) {
                            Logger.log(Level.FINE, "  receiving response, code: {0}", respCode);
                        }
                        boolean receiveResult = this.handleReceive(hconn);
                        boolean processResult = this.processResponse();
                        boolean bl = commandSucceeded = receiveResult && processResult;
                        if (!commandSucceeded && !this.isSilentFailureAllowed()) {
                            Logger.log(Level.WARNING, hconn.toString());
                            Logger.log(Level.WARNING, hconn.getContentType());
                            Logger.log(Level.WARNING, hconn.getContentEncoding());
                            Map<String, List<String>> ms2ls = hconn.getHeaderFields();
                            Logger.log(Level.WARNING, "Header Fields");
                            for (Map.Entry<String, List<String>> e : ms2ls.entrySet()) {
                                Logger.log(Level.WARNING, e.getKey() + " = ");
                                for (String v : e.getValue()) {
                                    Logger.log(Level.WARNING, "     " + v);
                                }
                            }
                        }
                        httpSucceeded = true;
                    }
                }
                catch (ProtocolException ex) {
                    this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ex.getLocalizedMessage(), true));
                    retries = 0;
                }
                catch (ConnectException ce) {
                    result = this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ce.getLocalizedMessage()));
                    return result;
                }
                catch (IOException ex) {
                    if (retries <= 0) {
                        result = this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ex.getLocalizedMessage()));
                        return result;
                    }
                }
                finally {
                    if (null != hconn) {
                        hconn.disconnect();
                    }
                }
                if (httpSucceeded || retries <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    Logger.log(Level.INFO, "Thread sleep interrupted: ", ie);
                }
            }
        }
        catch (MalformedURLException ex) {
            Logger.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        if (!commandSucceeded) return this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_FAILED, this.stateChangeArgs(null));
        return this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.stateChangeArgs(null));
    }
}

