/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tools.ide.admin.AdminFactoryHttp;
import org.glassfish.tools.ide.admin.AdminFactoryRest;
import org.glassfish.tools.ide.admin.Command;
import org.glassfish.tools.ide.admin.CommandException;
import org.glassfish.tools.ide.admin.Runner;
import org.glassfish.tools.ide.data.GlassFishAdminInterface;
import org.glassfish.tools.ide.data.GlassFishServer;
import org.glassfish.tools.ide.data.GlassFishVersion;
import org.glassfish.tools.ide.data.IdeContext;

public abstract class AdminFactory {
    private static final Logger LOG = Logger.getLogger(AdminFactory.class.getSimpleName());

    static AdminFactory getInstance(GlassFishVersion version) throws CommandException {
        switch (version) {
            case GF_1: {
                throw new CommandException("Unsupported GlassFish version");
            }
            case GF_2: 
            case GF_2_1: 
            case GF_2_1_1: {
                return AdminFactoryHttp.getInstance();
            }
            case GF_3: 
            case GF_3_0_1: 
            case GF_3_1: 
            case GF_3_1_1: 
            case GF_3_1_2: 
            case GF_4: {
                return AdminFactoryRest.getInstance();
            }
        }
        throw new CommandException("Unknown GlassFish version");
    }

    static AdminFactory getInstance(GlassFishAdminInterface adminInterface) throws CommandException {
        switch (adminInterface) {
            case REST: {
                return AdminFactoryRest.getInstance();
            }
            case HTTP: {
                return AdminFactoryHttp.getInstance();
            }
        }
        throw new CommandException("Unknown GlassFish administration interface type");
    }

    abstract Runner getRunner(GlassFishServer var1, Command var2, IdeContext var3);

    Runner newRunner(GlassFishServer srv, Command cmd, IdeContext ide, Class runnerClass) throws CommandException {
        Runner runner;
        Constructor con = null;
        try {
            con = runnerClass.getConstructor(GlassFishServer.class, Command.class, IdeContext.class);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (con != null) {
            Runner runner2;
            try {
                runner2 = (Runner)con.newInstance(srv, cmd, ide);
            }
            catch (InstantiationException ie) {
                throw new CommandException("Cannot initialize Runner class", ie);
            }
            catch (IllegalAccessException iae) {
                throw new CommandException("Cannot initialize Runner class", iae);
            }
            catch (InvocationTargetException ite) {
                throw new CommandException("Cannot initialize Runner class", ite);
            }
            return runner2;
        }
        try {
            con = runnerClass.getConstructor(GlassFishServer.class, Command.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new CommandException("Cannot initialize Runner class", nsme);
        }
        catch (SecurityException se) {
            throw new CommandException("Cannot initialize Runner class", se);
        }
        try {
            runner = (Runner)con.newInstance(srv, cmd);
        }
        catch (InstantiationException ie) {
            throw new CommandException("Cannot initialize Runner class", ie);
        }
        catch (IllegalAccessException iae) {
            throw new CommandException("Cannot initialize Runner class", iae);
        }
        catch (InvocationTargetException ite) {
            LOG.log(Level.WARNING, "Caught: ", ite.getMessage());
            Throwable t = ite.getCause();
            if (t != null) {
                LOG.log(Level.WARNING, "Caused by:", t.getMessage());
            }
            throw new CommandException("Cannot initialize Runner class", ite);
        }
        return runner;
    }
}

