/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.glassfish.tools.ide.logging.Logger;

public class GlassFishIdeException
extends RuntimeException {
    private static String formatMessage(String msg, Object ... arguments) {
        if (arguments != null && arguments.length > 0) {
            return MessageFormat.format(msg, arguments);
        }
        return msg;
    }

    public GlassFishIdeException() {
        Logger.log(Level.WARNING, "Caught GlassFishIdeException.");
    }

    public GlassFishIdeException(String msg) {
        super(msg);
        if (Logger.isLoggable(Level.WARNING)) {
            String hdr = "Caught GlassFishIdeException";
            String sep = msg != null ? ": " : ".";
            StringBuilder sb = new StringBuilder(hdr.length() + sep.length() + (msg != null ? msg.length() : 0));
            sb.append(hdr);
            sb.append(sep);
            if (msg != null) {
                sb.append(msg);
            }
            Logger.log(Level.WARNING, sb.toString());
        }
    }

    public GlassFishIdeException(String msg, Object ... arguments) {
        this(GlassFishIdeException.formatMessage(msg, arguments));
    }

    public GlassFishIdeException(String msg, Throwable cause) {
        super(msg, cause);
        if (Logger.isLoggable(Level.WARNING)) {
            String hdr = "Caught GlassFishIdeException";
            String sep = msg != null ? ": " : ".";
            StringBuilder sb = new StringBuilder(hdr.length() + sep.length() + (msg != null ? msg.length() : 0));
            sb.append(hdr);
            sb.append(sep);
            if (msg != null) {
                sb.append(msg);
            }
            Logger.log(Level.WARNING, sb.toString());
            if (cause != null) {
                String className = cause.getClass().getName();
                msg = cause.getMessage();
                sep = msg != null ? ": " : ".";
                hdr = "GlassFishIdeException was caused by ";
                sb = new StringBuilder(hdr.length() + className.length() + sep.length() + (msg != null ? msg.length() : 0));
                sb.append(hdr);
                sb.append(className);
                sb.append(sep);
                if (msg != null) {
                    sb.append(msg);
                }
                Logger.log(Level.WARNING, sb.toString());
            }
        }
    }
}

