/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.nodes;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.DependencyManagement;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public final class MavenNodeFactory {
    private static final String DELIMITER = " : ";

    private MavenNodeFactory() {
    }

    public static VersionNode createVersionNode(NBVersionInfo versionInfo, boolean fromMng) {
        return new VersionNode(versionInfo, fromMng);
    }

    public static ArtifactNode createArtifactNode(String name, List<NBVersionInfo> list) {
        return new ArtifactNode(name, list);
    }

    public static class ArtifactNode
    extends AbstractNode {
        private List<NBVersionInfo> versionInfos;
        private ArtifactNodeChildren myChildren = (ArtifactNodeChildren)this.getChildren();

        public ArtifactNode(String name, List<NBVersionInfo> list) {
            super((Children)new ArtifactNodeChildren(list));
            this.versionInfos = list;
            this.setName(name);
            this.setDisplayName(name);
        }

        public Image getIcon(int arg0) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/ArtifactBadge.png", (boolean)true);
            return badge;
        }

        public Image getOpenedIcon(int arg0) {
            return this.getIcon(arg0);
        }

        public List<NBVersionInfo> getVersionInfos() {
            return new ArrayList<NBVersionInfo>(this.versionInfos);
        }

        public void setVersionInfos(List<NBVersionInfo> infos) {
            this.versionInfos = infos;
            this.myChildren.setNewKeys(infos);
        }

        static class ArtifactNodeChildren
        extends Children.Keys<NBVersionInfo> {
            private List<NBVersionInfo> keys;

            public ArtifactNodeChildren(List<NBVersionInfo> keys) {
                this.keys = keys;
            }

            protected Node[] createNodes(NBVersionInfo arg0) {
                return new Node[]{new VersionNode(arg0, false)};
            }

            protected void addNotify() {
                this.setKeys(this.keys);
            }

            protected void setNewKeys(List<NBVersionInfo> keys) {
                this.keys = keys;
                this.setKeys(keys);
            }
        }
    }

    public static class VersionNode
    extends AbstractNode {
        private NBVersionInfo nbvi;
        private boolean fromDepMng;

        public VersionNode(NBVersionInfo versionInfo, boolean fromDepMng) {
            super(Children.LEAF, fromDepMng ? Lookups.fixed((Object[])new Object[]{versionInfo, new DependencyManagement()}) : Lookups.fixed((Object[])new Object[]{versionInfo}));
            this.nbvi = versionInfo;
            this.fromDepMng = fromDepMng;
            this.setName(versionInfo.getVersion());
            StringBuilder sb = new StringBuilder();
            if (fromDepMng) {
                sb.append(this.nbvi.getGroupId());
                sb.append(MavenNodeFactory.DELIMITER);
                sb.append(this.nbvi.getArtifactId());
                sb.append(MavenNodeFactory.DELIMITER);
            } else {
                sb.append(this.nbvi.getVersion());
            }
            sb.append(" [ ");
            sb.append(this.nbvi.getType());
            String classifier = this.nbvi.getClassifier();
            if (classifier != null) {
                sb.append(",");
                sb.append(classifier);
            }
            sb.append(" ] ");
            String repo = this.nbvi.getRepoId();
            if (repo != null) {
                sb.append(" - ");
                sb.append(repo);
            }
            this.setDisplayName(sb.toString());
            this.setIconBaseWithExtension("org/netbeans/modules/maven/spi/nodes/DependencyJar.gif");
        }

        public NBVersionInfo getNBVersionInfo() {
            return this.nbvi;
        }

        public String getShortDescription() {
            return this.nbvi.toString();
        }
    }
}

