/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.util.NbPreferences;

class SourceJavadocByHash {
    private static Preferences node(boolean javadoc) {
        return NbPreferences.forModule(SourceJavadocByHash.class).node(javadoc ? "attachedJavadoc" : "attachedSource");
    }

    public static void register(@NonNull URL root, @NonNull File[] result, boolean javadoc) {
        StringBuilder sb = new StringBuilder();
        for (File res : result) {
            sb.append("||").append(res.getAbsolutePath());
        }
        SourceJavadocByHash.node(javadoc).put(root.toString(), sb.substring(2));
    }

    @CheckForNull
    public static File[] find(@NonNull URL root, boolean javadoc) {
        String k = root.toString();
        Preferences n = SourceJavadocByHash.node(javadoc);
        String v = n.get(k, null);
        if (v == null) {
            return null;
        }
        String[] split = StringUtils.split((String)v, (String)"||");
        ArrayList<File> toRet = new ArrayList<File>();
        for (String vv : split) {
            File f = FileUtilities.convertStringToFile(vv);
            if (f.isFile()) {
                toRet.add(f);
                continue;
            }
            n.remove(k);
        }
        return toRet.toArray(new File[0]);
    }

    private SourceJavadocByHash() {
    }
}

