/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.maven.NbMavenProjectFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class RepositoryMavenCPProvider
implements ClassPathProvider {
    private static final Logger LOG = Logger.getLogger(RepositoryMavenCPProvider.class.getName());

    public ClassPath findClassPath(FileObject file, String type) {
        File parentParent;
        File parent;
        File sourceFile;
        if (!NbMavenProjectFactory.isAtLeastOneMavenProjectAround() && !EmbedderFactory.isProjectEmbedderLoaded()) {
            return null;
        }
        FileObject archive = FileUtil.getArchiveFile((FileObject)file);
        if (archive != null && archive.getNameExt().endsWith("-sources.jar") && (sourceFile = FileUtil.toFile((FileObject)archive)) != null && (parent = sourceFile.getParentFile()) != null && (parentParent = parent.getParentFile()) != null) {
            String artifact = parentParent.getName();
            String version = parent.getName();
            if (archive.getNameExt().startsWith(artifact + "-" + version)) {
                String groupId;
                File bin = new File(parent, artifact + "-" + version + ".jar");
                File pom = new File(parent, artifact + "-" + version + ".pom");
                URI localRepo = Utilities.toURI((File)EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile());
                URI rel = localRepo.relativize(Utilities.toURI((File)parentParent.getParentFile()));
                if (!rel.isAbsolute() && (groupId = rel.getPath()) != null && !groupId.equals("")) {
                    if ((groupId = groupId.replace("/", ".")).endsWith(".")) {
                        groupId = groupId.substring(0, groupId.length() - 1);
                    }
                    if ("classpath/source".equals(type)) {
                        return ClassPathFactory.createClassPath((ClassPathImplementation)this.createSourceCPI(sourceFile));
                    }
                    if ("classpath/boot".equals(type)) {
                        return JavaPlatform.getDefault().getBootstrapLibraries();
                    }
                    if ("classpath/compile".equals(type)) {
                        MavenProject mp = this.loadMavenProject(pom, groupId, artifact, version);
                        return ClassPathFactory.createClassPath((ClassPathImplementation)this.createCompileCPI(mp, bin));
                    }
                    if ("classpath/execute".equals(type)) {
                        MavenProject mp = this.loadMavenProject(pom, groupId, artifact, version);
                        return ClassPathFactory.createClassPath((ClassPathImplementation)this.createExecuteCPI(mp, bin));
                    }
                }
            }
        }
        return null;
    }

    private MavenProject loadMavenProject(File pom, String groupId, String artifactId, String version) {
        MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
        Artifact projectArtifact = embedder.createArtifact(groupId, artifactId, version, "jar");
        try {
            ProjectBuildingRequest dpbr = embedder.createMavenExecutionRequest().getProjectBuildingRequest();
            dpbr.setValidationLevel(0);
            dpbr.setProcessPlugins(false);
            dpbr.setResolveDependencies(true);
            ArrayList remoteRepos = new ArrayList();
            dpbr.setRemoteRepositories(remoteRepos);
            ProjectBuildingResult res = embedder.buildProject(projectArtifact, dpbr);
            if (res.getProject() != null) {
                return res.getProject();
            }
            LOG.log(Level.INFO, "No project model from repository for {0}: {1}", new Object[]{projectArtifact, res.getProblems()});
        }
        catch (ProjectBuildingException ex) {
            LOG.log(Level.FINER, "Failed to load project model from repository for {0}: {1}", new Object[]{projectArtifact, ex});
        }
        catch (Exception exception) {
            LOG.log(Level.FINER, "Failed to load project model from repository for " + projectArtifact, exception);
        }
        return null;
    }

    private ClassPathImplementation createCompileCPI(MavenProject project, File binary) {
        ArrayList<PathResourceImplementation> items = new ArrayList<PathResourceImplementation>();
        items.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)binary)));
        if (project != null) {
            for (Artifact s : project.getCompileArtifacts()) {
                if (s.getFile() == null) continue;
                items.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)s.getFile())));
            }
        }
        return ClassPathSupport.createClassPathImplementation(items);
    }

    private ClassPathImplementation createExecuteCPI(MavenProject project, File binary) {
        ArrayList<PathResourceImplementation> items = new ArrayList<PathResourceImplementation>();
        items.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)binary)));
        if (project != null) {
            for (Artifact s : project.getRuntimeArtifacts()) {
                if (s.getFile() == null) continue;
                items.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)s.getFile())));
            }
        }
        return ClassPathSupport.createClassPathImplementation(items);
    }

    private ClassPathImplementation createSourceCPI(File sourceFile) {
        return ClassPathSupport.createClassPathImplementation(Collections.singletonList(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)sourceFile))));
    }
}

