/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class MavenSourceLevelImpl
implements SourceLevelQueryImplementation2 {
    private final Project project;

    public MavenSourceLevelImpl(Project proj) {
        this.project = proj;
    }

    private String getSourceLevelString(FileObject javaFile) {
        File file = FileUtil.toFile((FileObject)javaFile);
        if (file == null) {
            return null;
        }
        URI uri = Utilities.toURI((File)file);
        assert ("file".equals(uri.getScheme()));
        String goal = "compile";
        NbMavenProjectImpl nbprj = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI testuri : nbprj.getSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        for (URI testuri : nbprj.getGeneratedSourceRoots(true)) {
            if (!uri.getPath().startsWith(testuri.getPath())) continue;
            goal = "testCompile";
        }
        String sourceLevel = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "source", goal, "maven.compiler.source");
        if (sourceLevel != null) {
            return sourceLevel;
        }
        String version = PluginPropertyUtils.getPluginVersion(nbprj.getOriginalMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
        if (version == null || new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("2.3")) >= 0) {
            return "1.5";
        }
        return "1.3";
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        return new ResultImpl(javaFile);
    }

    private class ResultImpl
    implements SourceLevelQueryImplementation2.Result,
    PropertyChangeListener {
        private final FileObject javaFile;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MavenSourceLevelImpl.access$000(MavenSourceLevelImpl.this).getLookup().lookup(NbMavenProject.class));

        ResultImpl(FileObject javaFile) {
            this.javaFile = javaFile;
            ((NbMavenProject)MavenSourceLevelImpl.this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.pcl);
        }

        public String getSourceLevel() {
            return MavenSourceLevelImpl.this.getSourceLevelString(this.javaFile);
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.cs.fireChange();
            }
        }
    }
}

