/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.maven.queries.RepositoryForBinaryQueryImpl;
import org.netbeans.modules.maven.queries.SourceJavadocByHash;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class MavenSourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    private static final RequestProcessor RP = new RequestProcessor(MavenSourceJavadocAttacher.class.getName(), 5);

    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, false);
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, true);
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final boolean javadoc) throws IOException {
        List candidates;
        boolean byHash;
        final File file = FileUtil.archiveOrDirForURL((URL)root);
        if (file == null) {
            return false;
        }
        String[] coordinates = MavenFileOwnerQueryImpl.findCoordinates(file);
        boolean bl = byHash = coordinates == null;
        if (!byHash) {
            candidates = RepositoryQueries.getRecordsResult((String)coordinates[0], (String)coordinates[1], (String)coordinates[2], null).getResults();
        } else if (file.isFile()) {
            candidates = RepositoryQueries.findBySHA1Result((File)file, null).getResults();
        } else {
            return false;
        }
        NBVersionInfo defined = null;
        for (NBVersionInfo nbvi : candidates) {
            if (!(javadoc ? nbvi.isJavadocExists() : nbvi.isSourcesExists())) continue;
            defined = nbvi;
            break;
        }
        if (defined == null) {
            return false;
        }
        final NBVersionInfo _defined = defined;
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean attached = false;
                try {
                    MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
                    Artifact art = online.createArtifactWithClassifier(_defined.getGroupId(), _defined.getArtifactId(), _defined.getVersion(), "jar", javadoc ? "javadoc" : "sources");
                    AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.attaching(art.getId()), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"attach")}, (Cancellable)ProgressTransferListener.cancellable(), null);
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
                    try {
                        hndl.start();
                        List repos = RepositoryPreferences.getInstance().remoteRepositories(online);
                        online.resolve(art, repos, online.getLocalRepository());
                        File result = art.getFile();
                        if (result.isFile()) {
                            attached = true;
                            if (!byHash) return;
                            SourceJavadocByHash.register(root, new File[]{result}, javadoc);
                            return;
                        }
                        if (!file.isFile()) return;
                        List<RepositoryForBinaryQueryImpl.Coordinates> coordinates = RepositoryForBinaryQueryImpl.getShadedCoordinates(result);
                        ArrayList<File> res = new ArrayList<File>();
                        if (coordinates == null) return;
                        for (RepositoryForBinaryQueryImpl.Coordinates coordinate : coordinates) {
                            Artifact sources = EmbedderFactory.getOnlineEmbedder().createArtifactWithClassifier(coordinate.groupId, coordinate.artifactId, coordinate.version, "jar", javadoc ? "javadoc" : "sources");
                            online.resolve(sources, repos, online.getLocalRepository());
                            if (sources.getFile() == null || !sources.getFile().isFile()) continue;
                            res.add(sources.getFile());
                        }
                        attached = true;
                        if (!byHash) return;
                        SourceJavadocByHash.register(root, res.toArray(new File[0]), javadoc);
                        return;
                    }
                    catch (ThreadDeath d) {
                        hndl.finish();
                        ProgressTransferListener.clearAggregateHandle();
                        return;
                        catch (IllegalStateException ise) {
                            if (ise.getCause() instanceof ThreadDeath) return;
                            throw ise;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (AbstractArtifactResolutionException x) {
                                hndl.finish();
                                ProgressTransferListener.clearAggregateHandle();
                                return;
                            }
                        }
                    }
                    finally {
                        hndl.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
                finally {
                    if (attached) {
                        listener.attachmentSucceeded();
                    } else {
                        listener.attachmentFailed();
                    }
                }
            }
        });
        return true;
    }
}

