/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class MavenFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private final Project project;
    private static final String ENCODING_PARAM = "encoding";

    public MavenFileEncodingQueryImpl(Project proj) {
        this.project = proj;
    }

    public Charset getEncoding(FileObject file) {
        MavenProject mp = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        if (mp == null) {
            return Charset.defaultCharset();
        }
        try {
            String testcompileEnc;
            String compileEnc;
            FileObject src = FileUtilities.convertStringToFileObject(mp.getBuild().getSourceDirectory());
            if (src != null && (src.equals(file) || FileUtil.isParentOf((FileObject)src, (FileObject)file)) && (compileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "compile", "project.build.sourceEncoding")) != null && compileEnc.indexOf("${") == -1) {
                return Charset.forName(compileEnc);
            }
            FileObject testsrc = FileUtilities.convertStringToFileObject(mp.getBuild().getTestSourceDirectory());
            if (testsrc != null && (testsrc.equals(file) || FileUtil.isParentOf((FileObject)testsrc, (FileObject)file)) && (testcompileEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", ENCODING_PARAM, "testCompile", "project.build.sourceEncoding")) != null && testcompileEnc.indexOf("${") == -1) {
                return Charset.forName(testcompileEnc);
            }
            NbMavenProjectImpl impl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
            try {
                String resourceEnc;
                if (this.isWithin(impl.getResources(false), file) && (resourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "resources", "project.build.sourceEncoding")) != null && resourceEnc.indexOf("${") == -1) {
                    return Charset.forName(resourceEnc);
                }
            }
            catch (MalformedURLException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            try {
                String testresourceEnc;
                if (this.isWithin(impl.getResources(true), file) && (testresourceEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-resources-plugin", ENCODING_PARAM, "testResources", "project.build.sourceEncoding")) != null && testresourceEnc.indexOf("${") == -1) {
                    return Charset.forName(testresourceEnc);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            try {
                String siteEnc;
                if (this.isWithin(new URI[]{impl.getSiteDirectory()}, file) && (siteEnc = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-site-plugin", "inputEncoding", "site", "project.build.sourceEncoding")) != null && siteEnc.indexOf("${") == -1) {
                    return Charset.forName(siteEnc);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            String defEnc = mp.getProperties().getProperty("project.build.sourceEncoding");
            if (defEnc != null) {
                return Charset.forName(defEnc);
            }
        }
        catch (UnsupportedCharsetException uce) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, uce.getMessage(), uce);
        }
        catch (IllegalCharsetNameException icne) {
            Logger.getLogger(MavenFileEncodingQueryImpl.class.getName()).log(Level.FINE, icne.getMessage(), icne);
        }
        return Charset.defaultCharset();
    }

    private boolean isWithin(URI[] res, FileObject file) throws MalformedURLException {
        for (URI ur : res) {
            FileObject fo = URLMapper.findFileObject((URL)ur.toURL());
            if (fo == null || !fo.equals(file) && !FileUtil.isParentOf((FileObject)fo, (FileObject)file)) continue;
            return true;
        }
        return false;
    }
}

