/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.spi.nodes.SpecialIcon;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public final class Info
implements ProjectInformation,
PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(Info.class.getName(), 10);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Project project;

    public Info(Project project) {
        this.project = project;
    }

    public String getName() {
        NbMavenProject nb = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        return nb.getMavenProject().getId().replace(':', '_');
    }

    @NonNull
    public String getDisplayName() {
        final NbMavenProject nb = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (SwingUtilities.isEventDispatchThread() && !nb.isMavenProjectLoaded()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    nb.getMavenProject();
                    Info.this.pcs.firePropertyChange("displayName", null, null);
                }
            });
            return FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
        }
        MavenProject pr = nb.getMavenProject();
        if (NbMavenProject.isErrorPlaceholder(pr)) {
            return Bundle.LBL_misconfigured_project(this.project.getProjectDirectory().getNameExt());
        }
        String toReturn = pr.getName();
        if (toReturn == null) {
            String grId = pr.getGroupId();
            String artId = pr.getArtifactId();
            toReturn = grId != null && artId != null ? grId + ":" + artId : Bundle.TXT_Maven_project_at(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        }
        return toReturn;
    }

    public Icon getIcon() {
        final NbMavenProject nb = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (SwingUtilities.isEventDispatchThread() && !nb.isMavenProjectLoaded()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    nb.getMavenProject();
                    Info.this.pcs.firePropertyChange("icon", null, null);
                }
            });
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true);
        }
        SpecialIcon special = (SpecialIcon)this.project.getLookup().lookup(SpecialIcon.class);
        return special != null ? special.getIcon() : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true);
    }

    public Project getProject() {
        return this.project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.pcs.hasListeners(null)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName())) {
            this.pcs.firePropertyChange("name", null, null);
            this.pcs.firePropertyChange("displayName", null, null);
            this.pcs.firePropertyChange("icon", null, null);
        }
    }
}

