/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.OpenPOMAction;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.problems.BatchProblemNotifier;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProblemReporterImpl
implements ProblemReporter,
Comparator<ProblemReport>,
ProjectProblemsProvider {
    private static final String MISSING_J2EE = "MISSINGJ2EE";
    private static final String MISSING_APISUPPORT = "MISSINGAPISUPPORT";
    private static final String MISSING_DEPENDENCY = "MISSING_DEPENDENCY";
    private static final String BUILD_PARTICIPANT = "BUILD_PARTICIPANT";
    private static final String MISSING_PARENT = "MISSING_PARENT";
    private static final Logger LOG = Logger.getLogger(ProblemReporterImpl.class.getName());
    public static final RequestProcessor RP = new RequestProcessor(ProblemReporterImpl.class);
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Set<ProblemReport> reports;
    private final Set<Artifact> missingArtifacts;
    private final File projectPOMFile;
    private final RequestProcessor.Task reloadTask = RP.create(new Runnable(){

        @Override
        public void run() {
            LOG.log(Level.FINE, "actually reloading {0}", ProblemReporterImpl.this.projectPOMFile);
            ProblemReporterImpl.this.nbproject.fireProjectReload();
        }
    });
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            LOG.log(Level.FINE, "due to {0} scheduling reload of {1}", new Object[]{fe.getFile(), ProblemReporterImpl.this.projectPOMFile});
            ProblemReporterImpl.this.reloadTask.schedule(1000);
            File f = FileUtil.toFile((FileObject)fe.getFile());
            if (f != null) {
                BatchProblemNotifier.resolved(f);
            } else {
                LOG.log(Level.FINE, "no java.io.File from {0}", fe);
            }
        }
    };
    private final NbMavenProjectImpl nbproject;
    private ModuleInfo j2eeInfo;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProblemReport rep;
            if ("enabled".equals(evt.getPropertyName()) && (rep = ProblemReporterImpl.this.getReportWithId(ProblemReporterImpl.MISSING_J2EE)) != null) {
                boolean hasj2ee;
                boolean bl = hasj2ee = ProblemReporterImpl.this.j2eeInfo != null && ProblemReporterImpl.this.j2eeInfo.isEnabled();
                if (hasj2ee) {
                    ProblemReporterImpl.this.removeReport(rep);
                    ProblemReporterImpl.this.j2eeInfo.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    };
    private final PropertyChangeSupport chs = new PropertyChangeSupport(this);
    public static final String ACT_START_MESSAGE = "START_MESSAGE";

    public ProblemReporterImpl(NbMavenProjectImpl proj) {
        this.reports = new TreeSet<ProblemReport>(this);
        this.missingArtifacts = new HashSet<Artifact>();
        this.nbproject = proj;
        this.projectPOMFile = this.nbproject.getPOMFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(ProblemReport report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.add(report);
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReports(ProblemReport[] report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (int i = 0; i < report.length; ++i) {
                assert (report[i] != null);
                this.reports.add(report[i]);
            }
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReport(ProblemReport report) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.remove(report);
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> list;
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            list = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener li : list) {
            li.stateChanged(new ChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport report : this.reports) {
                if (report.getSeverityLevel() >= 10) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProblemReport> getReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new ArrayList<ProblemReport>(this.reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMissingArtifact(Artifact a) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            a = EmbedderFactory.getProjectEmbedder().getLocalRepository().find(a);
            if (this.missingArtifacts.add(a)) {
                File f = a.getFile();
                LOG.log(Level.FINE, "listening to {0} from {1}", new Object[]{f, this.projectPOMFile});
                FileUtil.addFileChangeListener((FileChangeListener)this.fcl, (File)f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Artifact> getMissingArtifacts() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new TreeSet<Artifact>(this.missingArtifacts);
        }
    }

    public boolean hasReportWithId(String id) {
        return this.getReportWithId(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemReport getReportWithId(String id) {
        assert (id != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport rep : this.reports) {
                if (!id.equals(rep.getId())) continue;
                return rep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReports() {
        boolean hasAny;
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            hasAny = !this.reports.isEmpty();
            this.reports.clear();
            Iterator<Artifact> as = this.missingArtifacts.iterator();
            while (as.hasNext()) {
                File f = as.next().getFile();
                if (f != null) {
                    LOG.log(Level.FINE, "ceasing to listen to {0} from {1}", new Object[]{f, this.projectPOMFile});
                    FileUtil.removeFileChangeListener((FileChangeListener)this.fcl, (File)f);
                    if (f.isFile()) {
                        BatchProblemNotifier.resolved(f);
                    }
                }
                as.remove();
            }
            this.missingArtifacts.clear();
        }
        if (hasAny) {
            this.fireChange();
            this.firePropertyChange();
        }
        ((PluginArtifactsCache)EmbedderFactory.getProjectEmbedder().lookupComponent(PluginArtifactsCache.class)).flush();
    }

    @Override
    public int compare(ProblemReport o1, ProblemReport o2) {
        int ret = o1.getSeverityLevel() - o2.getSeverityLevel();
        if (ret != 0) {
            return ret;
        }
        return o1.hashCode() - o2.hashCode();
    }

    private ModuleInfo findJ2eeModule() {
        Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo info : infos) {
            if (!"org.netbeans.modules.maven.j2ee".equals(info.getCodeNameBase())) continue;
            return info;
        }
        return null;
    }

    public void doIDEConfigChecks() {
        String packaging = this.nbproject.getProjectWatcher().getPackagingType();
        if ("war".equals(packaging) || "ear".equals(packaging) || "ejb".equals(packaging)) {
            boolean foundJ2ee;
            if (this.j2eeInfo == null) {
                this.j2eeInfo = this.findJ2eeModule();
            }
            boolean bl = foundJ2ee = this.j2eeInfo != null && this.j2eeInfo.isEnabled();
            if (!foundJ2ee) {
                if (!this.hasReportWithId(MISSING_J2EE)) {
                    ProblemReport report = new ProblemReport(5, Bundle.ERR_MissingJ2eeModule(), Bundle.MSG_MissingJ2eeModule(), null);
                    report.setId(MISSING_J2EE);
                    this.addReport(report);
                    if (this.j2eeInfo != null) {
                        this.j2eeInfo.addPropertyChangeListener(this.listener);
                    }
                }
            } else if (this.j2eeInfo != null) {
                this.j2eeInfo.removePropertyChangeListener(this.listener);
            }
        } else if ("nbm".equals(packaging)) {
            Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
            boolean foundApisupport = false;
            for (ModuleInfo info : infos) {
                if (!"org.netbeans.modules.maven.apisupport".equals(info.getCodeNameBase()) || !info.isEnabled()) continue;
                foundApisupport = true;
                break;
            }
            if (!foundApisupport) {
                ProblemReport report = new ProblemReport(5, Bundle.ERR_MissingApisupportModule(), Bundle.MSG_MissingApisupportModule(), null);
                report.setId(MISSING_APISUPPORT);
                this.addReport(report);
            }
        }
    }

    public void doArtifactChecks(@NonNull MavenProject project) {
        if (MavenProjectCache.unknownBuildParticipantObserved(project)) {
            StringBuilder sb = new StringBuilder();
            for (String s : MavenProjectCache.getUnknownBuildParticipantsClassNames(project)) {
                sb.append(s).append("\n");
            }
            ProblemReport report = new ProblemReport(5, Bundle.ERR_Participant(), Bundle.MSG_Participant(sb.toString()), null);
            report.setId(BUILD_PARTICIPANT);
            this.addReport(report);
        }
        this.checkParents(project);
        boolean missingNonSibling = false;
        ArrayList<Artifact> missingJars = new ArrayList<Artifact>();
        for (Artifact art : project.getArtifacts()) {
            File file = art.getFile();
            if (file == null || !file.exists()) {
                this.addMissingArtifact(art);
                if ("system".equals(art.getScope())) {
                    ProblemReport report = new ProblemReport(5, Bundle.ERR_SystemScope(), Bundle.MSG_SystemScope(), OpenPOMAction.instance().createContextAwareInstance(Lookups.fixed((Object[])new Object[]{this.nbproject})));
                    this.addReport(report);
                    continue;
                }
                if (file == null) {
                    missingNonSibling = true;
                } else {
                    SourceForBinaryQuery.Result2 result = SourceForBinaryQuery.findSourceRoots2((URL)FileUtil.urlForArchiveOrDir((File)file));
                    if (!result.preferSources() || result.getRoots().length == 0) {
                        missingNonSibling = true;
                    }
                }
                missingJars.add(art);
                continue;
            }
            if (!NbArtifactFixer.isFallbackFile(file)) continue;
            this.addMissingArtifact(art);
            missingJars.add(art);
            missingNonSibling = true;
        }
        if (!missingJars.isEmpty()) {
            StringBuilder mess = new StringBuilder();
            for (Artifact art : missingJars) {
                mess.append(art.getId()).append('\n');
            }
            ProblemReport report = new ProblemReport(missingNonSibling ? 5 : 10, Bundle.ERR_NonLocal(), Bundle.MSG_NonLocal(mess), new SanityBuildAction(this.nbproject));
            report.setId(MISSING_DEPENDENCY);
            this.addReport(report);
        }
    }

    private void checkParents(@NonNull MavenProject project) {
        List mdls = MavenEmbedder.getModelDescriptors((MavenProject)project);
        boolean first = true;
        if (mdls == null) {
            return;
        }
        for (MavenEmbedder.ModelDescription m : mdls) {
            if (first) {
                first = false;
                continue;
            }
            if (!"F@LLB@CK".equals(m.getName())) continue;
            ProblemReport report = new ProblemReport(0, Bundle.ERR_NoParent(), Bundle.MSG_NoParent(m.getId()), new SanityBuildAction(this.nbproject));
            report.setId(MISSING_PARENT);
            this.addReport(report);
            this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(m.getGroupId(), m.getArtifactId(), m.getVersion(), "pom"));
        }
    }

    public void reportExceptions(MavenExecutionResult res) throws MissingResourceException {
        for (Throwable e : res.getExceptions()) {
            ProblemReport report;
            LOG.log(Level.FINE, "Error on loading project " + this.projectPOMFile, e);
            String msg = e.getMessage();
            if (e instanceof ArtifactResolutionException) {
                report = new ProblemReport(0, Bundle.TXT_Artifact_Resolution_problem(), msg, null);
                this.addReport(report);
                this.addMissingArtifact(((ArtifactResolutionException)e).getArtifact());
                continue;
            }
            if (e instanceof ArtifactNotFoundException) {
                report = new ProblemReport(0, Bundle.TXT_Artifact_Not_Found(), msg, null);
                this.addReport(report);
                this.addMissingArtifact(((ArtifactNotFoundException)e).getArtifact());
                continue;
            }
            if (e instanceof ProjectBuildingException) {
                this.addReport(new ProblemReport(0, Bundle.TXT_Cannot_Load_Project(), msg, new SanityBuildAction(this.nbproject)));
                if (!(e.getCause() instanceof ModelBuildingException)) continue;
                ModelBuildingException mbe = (ModelBuildingException)e.getCause();
                for (ModelProblem mp : mbe.getProblems()) {
                    LOG.log(Level.FINE, mp.toString(), mp.getException());
                    if (mp.getException() instanceof UnresolvableModelException) {
                        UnresolvableModelException ume = (UnresolvableModelException)mp.getException();
                        this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createProjectArtifact(ume.getGroupId(), ume.getArtifactId(), ume.getVersion()));
                        continue;
                    }
                    if (!(mp.getException() instanceof PluginResolutionException)) continue;
                    Plugin plugin = ((PluginResolutionException)mp.getException()).getPlugin();
                    this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), "jar"));
                }
                continue;
            }
            LOG.log(Level.INFO, "Exception thrown while loading maven project at " + this.projectPOMFile, e);
            report = new ProblemReport(0, "Error reading project model", msg, null);
            this.addReport(report);
        }
    }

    public static Action createOpenFileAction(FileObject fo) {
        return new OpenActions(fo);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.chs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.chs.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (ProblemReport pr : this.getReports()) {
            MavenProblemResolver res = new MavenProblemResolver(pr.getCorrectiveAction(), pr.getId() + "|" + this.nbproject.getPOMFile());
            ProjectProblemsProvider.ProjectProblem pp = pr.getSeverityLevel() == 0 ? ProjectProblemsProvider.ProjectProblem.createError((String)pr.getShortDescription(), (String)pr.getLongDescription(), (ProjectProblemResolver)res) : ProjectProblemsProvider.ProjectProblem.createWarning((String)pr.getShortDescription(), (String)pr.getLongDescription(), (ProjectProblemResolver)res);
            toRet.add(pp);
        }
        return toRet;
    }

    private void firePropertyChange() {
        this.chs.firePropertyChange("problems", null, null);
    }

    public static class MavenProblemResolver
    implements ProjectProblemResolver {
        private final Action action;
        private final String id;

        public MavenProblemResolver(Action correctiveAction, String id) {
            this.action = correctiveAction;
            this.id = id;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() throws Exception {
                    if (MavenProblemResolver.this.action != null) {
                        MavenProblemResolver.this.action.actionPerformed(null);
                        String text = (String)MavenProblemResolver.this.action.getValue(ProblemReporterImpl.ACT_START_MESSAGE);
                        if (text != null) {
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)text);
                        }
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.TXT_No_Res());
                }
            });
            RP.post(toRet);
            return toRet;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenProblemResolver other = (MavenProblemResolver)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    private static class OpenActions
    extends AbstractAction {
        private FileObject fo;

        OpenActions(FileObject file) {
            this.putValue("Name", Bundle.TXT_OPEN_FILE());
            this.putValue(ProblemReporterImpl.ACT_START_MESSAGE, Bundle.ACT_OPEN_FILE_START());
            this.fo = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)this.fo);
                    EditCookie edit = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

