/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputUtils;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.api.output.TestOutputObserver;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestOutputListenerProvider
implements OutputProcessor {
    private static final String[] TESTGOALS = new String[]{"mojo-execute#surefire:test"};
    private Pattern failSeparatePattern = Pattern.compile("(?:\\[surefire\\] )?Tests run.*[<]* FAILURE[!]*[\\s]*", 32);
    private Pattern failWindowsPattern1 = Pattern.compile("(?:\\[surefire\\] )?Tests run.*", 32);
    private Pattern failWindowsPattern2 = Pattern.compile(".*[<]* FAILURE [!]*.*", 32);
    private Pattern outDirPattern;
    private Pattern outDirPattern2;
    private Pattern runningPattern = Pattern.compile("(?:\\[surefire\\] )?Running (.*)", 32);
    private static final Logger LOG = Logger.getLogger(TestOutputListenerProvider.class.getName());
    String outputDir;
    String runningTestClass;
    private String delayedLine;

    public TestOutputListenerProvider() {
        this.outDirPattern = Pattern.compile(".*Surefire report directory\\: (.*)", 32);
        this.outDirPattern2 = Pattern.compile(".*Setting reports dir\\: (.*)", 32);
    }

    public String[] getWatchedGoals() {
        return TESTGOALS;
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.delayedLine != null) {
            match = this.failWindowsPattern2.matcher(line);
            if (match.matches()) {
                visitor.setOutputListener(new TestOutputListener(this.runningTestClass, this.outputDir), true);
                visitor.setLine(this.delayedLine + line);
            } else {
                visitor.setLine(this.delayedLine + "\n" + line);
            }
            this.delayedLine = null;
        }
        if ((match = this.outDirPattern.matcher(line)).matches()) {
            this.outputDir = match.group(1);
            return;
        }
        match = this.outDirPattern2.matcher(line);
        if (match.matches()) {
            this.outputDir = match.group(1);
            return;
        }
        match = this.runningPattern.matcher(line);
        if (match.matches()) {
            this.runningTestClass = match.group(1);
            return;
        }
        match = this.failSeparatePattern.matcher(line);
        if (match.matches()) {
            visitor.setOutputListener(new TestOutputListener(this.runningTestClass, this.outputDir), true);
            return;
        }
        match = this.failWindowsPattern1.matcher(line);
        if (match.matches()) {
            visitor.skipLine();
            this.delayedLine = line;
        }
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return TESTGOALS;
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class TestOutputListener
    implements OutputListener {
        private String testname;
        private String outputDir;
        private Pattern testNamePattern = Pattern.compile(".*\\((.*)\\).*<<< (?:FAILURE)?(?:ERROR)?!\\s*");

        public TestOutputListener(String test, String outDir) {
            this.testname = test;
            this.outputDir = outDir;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            FileObject outDir = null;
            if (this.outputDir != null) {
                File fl = FileUtil.normalizeFile((File)new File(this.outputDir));
                FileUtil.refreshFor((File[])new File[]{fl});
                outDir = FileUtil.toFileObject((File)fl);
            }
            if (outDir == null) {
                LOG.log(Level.INFO, "Cannot find path {0} to follow link in Output Window.", this.outputDir);
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CannotFollowLink1());
                return;
            }
            outDir.refresh();
            Project prj = FileOwnerQuery.getOwner(outDir);
            if (prj != null) {
                NbMavenProjectImpl nbprj = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
                if (nbprj == null) {
                    LOG.log(Level.INFO, "Cannot find owning maven project for {0} to follow link in Output Window.", this.outputDir);
                    StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CannotFollowLink3());
                    return;
                }
                String reportNameSuffix = PluginPropertyUtils.getPluginProperty(nbprj.getOriginalMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "reportNameSuffix", "test", "surefire.reportNameSuffix");
                String suffix = reportNameSuffix;
                suffix = suffix == null ? "" : "-" + suffix;
                FileObject report = outDir.getFileObject(this.testname + suffix + ".txt");
                String tsd = nbprj.getOriginalMavenProject().getBuild().getTestSourceDirectory();
                if (tsd == null) {
                    tsd = new File(FileUtil.toFile((FileObject)prj.getProjectDirectory()), "src" + File.separator + "test" + File.separator + "java").getAbsolutePath();
                }
                File testDir = new File(tsd);
                if (report != null) {
                    String nm = this.testname.lastIndexOf(46) > -1 ? this.testname.substring(this.testname.lastIndexOf(46)) : this.testname;
                    this.openLog(report, nm, testDir);
                } else {
                    LOG.log(Level.INFO, "Cannot find report path {0}{1}.txt to follow link in Output Window.", new Object[]{this.outputDir, this.testname});
                    StatusDisplayer.getDefault().setStatusText(Bundle.MSG_CannotFollowLink2());
                }
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        private void openLog(final FileObject fo, String title, final File testDir) {
            try {
                IOProvider.getDefault().getIO(title, false).getOut().reset();
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            final InputOutput io = IOProvider.getDefault().getIO(title, false);
            io.select();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedReader reader = null;
                    OutputWriter writer = io.getOut();
                    Collection<? extends TestOutputObserver> observers = this.getObservers();
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                        ClassPath classPath = null;
                        Project project = null;
                        while ((line = reader.readLine()) != null) {
                            String testClassName;
                            File file;
                            FileObject testFileObject;
                            Matcher m = TestOutputListener.this.testNamePattern.matcher(line);
                            if (m.matches() && (testFileObject = FileUtil.toFileObject((File)(file = new File(testDir, testClassName = m.group(1).replace('.', File.separatorChar) + ".java")))) != null) {
                                classPath = ClassPath.getClassPath((FileObject)testFileObject, (String)"classpath/execute");
                                project = FileOwnerQuery.getOwner((FileObject)testFileObject);
                            }
                            for (TestOutputObserver testOutputObserver : observers) {
                                testOutputObserver.processLine(line, project);
                            }
                            if (classPath != null) {
                                OutputListener list = OutputUtils.matchStackTraceLine(line, classPath);
                                if (list != null) {
                                    writer.println(line, list, true);
                                    continue;
                                }
                                writer.println(line);
                                continue;
                            }
                            writer.println(line);
                        }
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify((Throwable)exc);
                    }
                    finally {
                        writer.close();
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }

                private Collection<? extends TestOutputObserver> getObservers() {
                    Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(TestOutputObserver.class));
                    return result.allInstances();
                }
            });
        }
    }
}

