/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GlobalOutputProcessor
implements OutputProcessor {
    private static final String SECTION_PROJECT = "project-execute";
    static final Pattern DOWNLOAD = Pattern.compile("^(\\d+(/\\d*)? ?(M|K|b|KB|B|\\?)\\s*)+$");
    private static final Pattern LOW_MVN = Pattern.compile("(.*)Error resolving version for (.*): Plugin requires Maven version (.*)");
    private static final Pattern HELP = Pattern.compile("\\[Help \\d+\\] (https?://.+)");
    static final Pattern MODEL_PROBLEM = Pattern.compile(".+ @ (?:\\S+, (.+), )?line (\\d+), column (\\d+)");
    static final Pattern MODEL_PROBLEM2 = Pattern.compile(".*Non-parseable POM (.+)pom.xml: .* @ (.*pom.xml)?,? ?line (\\d+), column (\\d+) .*");
    private static final Logger LOG = Logger.getLogger(GlobalOutputProcessor.class.getName());
    private final RunConfig config;

    GlobalOutputProcessor(RunConfig config) {
        this.config = config;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return new String[]{SECTION_PROJECT};
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher m3;
        if (DOWNLOAD.matcher(line).matches()) {
            visitor.skipLine();
            return;
        }
        if ("BUILD SUCCESSFUL".equals(line)) {
            visitor.setColor(Color.GREEN.darker().darker());
            return;
        }
        if (LOW_MVN.matcher(line).matches()) {
            visitor.setLine(line + '\n' + Bundle.TXT_ChangeSettings());
            visitor.setColor(Color.RED);
            visitor.setOutputListener(new OutputListener(){

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineAction(OutputEvent ev) {
                    OptionsDisplayer.getDefault().open("Java/Maven");
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
            return;
        }
        final Matcher m = HELP.matcher(line);
        if (m.matches()) {
            visitor.setOutputListener(new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    try {
                        HtmlBrowser.URLDisplayer.getDefault().showURLExternal(new URL(m.group(1)));
                    }
                    catch (MalformedURLException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
            return;
        }
        Matcher m2 = MODEL_PROBLEM.matcher(line);
        if (m2.matches()) {
            visitor.setOutputListener(new OL(m2.group(1), Integer.parseInt(m2.group(2)), Integer.parseInt(m2.group(3)), this.config));
        }
        if ((m3 = MODEL_PROBLEM2.matcher(line)).matches()) {
            String loc = m3.group(2) != null ? m3.group(2) : m3.group(1) + "pom.xml";
            visitor.setOutputListener(new OL(loc, Integer.parseInt(m3.group(3)), Integer.parseInt(m3.group(4)), this.config));
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        if (!sequenceId.startsWith(SECTION_PROJECT)) {
            visitor.setLine("[" + sequenceId.substring("mojo-execute#".length()) + "]");
            visitor.setColor(Color.GRAY);
        }
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class OL
    implements OutputListener {
        private final int column;
        private final int line;
        private final String loc;
        private final RunConfig config;

        public OL(String loc, int line, int column, RunConfig config) {
            this.loc = loc;
            this.line = line;
            this.column = column;
            this.config = config;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            DataObject pomDO;
            File pom = this.loc == null ? new File(this.config.getExecutionDirectory(), "pom.xml") : FileUtilities.convertStringToFile(this.loc);
            FileObject pomFO = FileUtil.toFileObject((File)pom);
            if (pomFO == null) {
                LOG.log(Level.WARNING, "no such file: {0}", pom);
                return;
            }
            try {
                pomDO = DataObject.find((FileObject)pomFO);
            }
            catch (DataObjectNotFoundException x) {
                LOG.log(Level.INFO, null, x);
                return;
            }
            LineCookie lc = (LineCookie)pomDO.getLookup().lookup(LineCookie.class);
            if (lc == null) {
                LOG.log(Level.WARNING, "no LineCookie in {0}", pom);
                return;
            }
            try {
                lc.getLineSet().getOriginal(this.line - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, this.column - 1);
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.WARNING, "no such line {0} in {1}: {2}", new Object[]{this.line, pom, x});
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

