/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.dependencies.DependencyExcludeNodeVisitor;
import org.netbeans.modules.maven.dependencies.ExcludeDependencyPanel;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.netbeans.modules.maven.nodes.InstallDocSourcePanel;
import org.netbeans.modules.maven.nodes.InstallPanel;
import org.netbeans.modules.maven.nodes.PathFinders;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.maven.queries.RepositoryForBinaryQueryImpl;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Cancellable;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class DependencyNode
extends AbstractNode
implements PreferenceChangeListener {
    private static final String JAVADOC_BADGE_ICON = "org/netbeans/modules/maven/DependencyJavadocIncluded.png";
    private static final String SOURCE_BADGE_ICON = "org/netbeans/modules/maven/DependencySrcIncluded.png";
    private static final String MANAGED_BADGE_ICON = "org/netbeans/modules/maven/DependencyManaged.png";
    private static final String ARTIFACT_ICON = "org/netbeans/modules/maven/ArtifactIcon.png";
    private static final String DEPENDENCY_ICON = "org/netbeans/modules/maven/DependencyIcon.png";
    private static final String MAVEN_ICON = "org/netbeans/modules/maven/resources/Maven2Icon.gif";
    private static final String TRANSITIVE_ARTIFACT_ICON = "org/netbeans/modules/maven/TransitiveArtifactIcon.png";
    private static final String TRANSITIVE_DEPENDENCY_ICON = "org/netbeans/modules/maven/TransitiveDependencyIcon.png";
    private static final String TRANSITIVE_MAVEN_ICON = "org/netbeans/modules/maven/TransitiveMaven2Icon.gif";
    private Artifact art;
    private NbMavenProjectImpl project;
    private boolean longLiving;
    private PropertyChangeListener listener;
    private ChangeListener listener2;
    private AtomicReference<FileObject> fileObject;
    private AtomicBoolean sourceExists = new AtomicBoolean(false);
    private AtomicBoolean javadocExists = new AtomicBoolean(false);
    private volatile String iconBase = "org/netbeans/modules/maven/DependencyIcon.png";
    private static String toolTipJavadoc = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_JavadocBadge");
    private static String toolTipSource = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_SourceBadge");
    private static String toolTipMissing = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_MissingBadge");
    private static String toolTipManaged = "<img src=\"" + DependencyNode.class.getClassLoader().getResource("org/netbeans/modules/maven/DependencyManaged.png") + "\">&nbsp;" + NbBundle.getMessage(DependencyNode.class, (String)"ICON_ManagedBadge");
    private static final RequestProcessor RP = new RequestProcessor(DependencyNode.class);
    private static RemoveDependencyAction REMOVEDEPINSTANCE = new RemoveDependencyAction(Lookup.EMPTY);
    private static final String SHOW_MANAGED_DEPENDENCIES = "show.managed.dependencies";
    private static SetInCurrentAction SETINCURRENTINSTANCE = new SetInCurrentAction(Lookup.EMPTY);

    private static Children createChildren(@NullAllowed Node nodeDelegate) {
        return nodeDelegate == null ? Children.LEAF : new JarContentFilterChildren(nodeDelegate);
    }

    @NonNull
    private static Lookup createLookup(@NonNull Project project, @NonNull Artifact art, @NullAllowed Node nodeDelegate) {
        FileObject fo;
        PathFinder pathFinderDelegate = nodeDelegate == null ? null : (PathFinder)nodeDelegate.getLookup().lookup(PathFinder.class);
        FileObject fileObject = fo = nodeDelegate == null ? null : (FileObject)nodeDelegate.getLookup().lookup(FileObject.class);
        if (fo != null) {
            return Lookups.fixed((Object[])new Object[]{project, art, PathFinders.createDelegatingPathFinder(pathFinderDelegate), fo});
        }
        return Lookups.fixed((Object[])new Object[]{project, art, PathFinders.createDelegatingPathFinder(pathFinderDelegate)});
    }

    @CheckForNull
    private static Node createNodeDelegate(@NonNull Artifact art, FileObject fo, boolean longLiving) {
        if (!longLiving) {
            return null;
        }
        if (fo != null) {
            return PackageView.createPackageView((SourceGroup)new ArtifactSourceGroup(art));
        }
        return null;
    }

    public DependencyNode(NbMavenProjectImpl project, Artifact art, FileObject fo, boolean isLongLiving) {
        this(project, art, fo, isLongLiving, DependencyNode.createNodeDelegate(art, fo, isLongLiving));
    }

    private DependencyNode(NbMavenProjectImpl project, final Artifact art, FileObject fo, boolean isLongLiving, Node nodeDelegate) {
        super(DependencyNode.createChildren(nodeDelegate), DependencyNode.createLookup(project, art, nodeDelegate));
        this.project = project;
        this.art = art;
        this.fileObject = new AtomicReference<FileObject>(fo);
        this.longLiving = isLongLiving;
        if (this.longLiving) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            NbMavenProject.addPropertyChangeListener(project, WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)project.getProjectWatcher()));
            this.listener2 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    if (event instanceof MavenFileOwnerQueryImpl.GAVCHangeEvent) {
                        MavenFileOwnerQueryImpl.GAVCHangeEvent ev = (MavenFileOwnerQueryImpl.GAVCHangeEvent)event;
                        if (ev.matches(art)) {
                            DependencyNode.this.refreshNode();
                        }
                    } else {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
            DependenciesNode.prefs().addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)DependenciesNode.prefs()));
        }
        this.setDisplayName(this.createName(false));
        this.setIconBase(false);
        if (this.longLiving) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DependencyNode.this.refreshNode();
                }
            });
        }
    }

    public boolean isTransitive() {
        List trail = this.art.getDependencyTrail();
        return trail != null && trail.size() > 2;
    }

    public boolean isManaged() {
        DependencyManagement dm = this.project.getOriginalMavenProject().getDependencyManagement();
        if (dm != null) {
            List dmList = dm.getDependencies();
            for (org.apache.maven.model.Dependency d : dmList) {
                if (!this.art.getGroupId().equals(d.getGroupId()) || !this.art.getArtifactId().equals(d.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private void setIconBase(boolean longLiving) {
        String base = longLiving && this.isDependencyProjectAvailable() ? (this.isTransitive() ? TRANSITIVE_MAVEN_ICON : MAVEN_ICON) : (this.isTransitive() ? (this.isAddedToCP() ? TRANSITIVE_DEPENDENCY_ICON : TRANSITIVE_ARTIFACT_ICON) : (this.isAddedToCP() ? DEPENDENCY_ICON : ARTIFACT_ICON));
        this.iconBase = base;
        this.setIconBaseWithExtension(base);
    }

    public String getShortDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><i>").append(Bundle.DESC_Dep1()).append("</i><b> ").append(this.art.getGroupId()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep2()).append("</i><b> ").append(this.art.getArtifactId()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep3()).append("</i><b> ").append(this.art.getVersion()).append("</b><br><i>");
        buf.append(Bundle.DESC_Dep4()).append("</i><b> ").append(this.art.getType()).append("</b><br>");
        if (this.art.getClassifier() != null) {
            buf.append("<i>").append(Bundle.DESC_Dep5()).append("</i><b> ").append(this.art.getClassifier()).append("</b><br>");
        }
        buf.append("<i>").append(Bundle.DESC_scope()).append("</i><b> ").append(this.art.getScope()).append("</b><br>");
        List trail = this.art.getDependencyTrail();
        for (int i = trail.size() - 2; i > 0 && i < trail.size(); --i) {
            String[] id = ((String)trail.get(i)).split(":");
            buf.append("<i>").append(Bundle.DESC_via()).append("</i> ").append(id[1]).append("<br>");
        }
        return buf.toString();
    }

    private boolean isAddedToCP() {
        return this.art.getArtifactHandler().isAddedToClasspath();
    }

    private boolean isDependencyProjectAvailable() {
        return this.getDependencyProjectAvailable() != null;
    }

    private Project getDependencyProjectAvailable() {
        if ("system".equals(this.art.getScope())) {
            return null;
        }
        URI uri = org.openide.util.Utilities.toURI((File)this.art.getFile());
        return FileOwnerQuery.getOwner((URI)uri);
    }

    private void refreshNode() {
        Node nodeDelegate;
        Children childs;
        assert (!SwingUtilities.isEventDispatchThread());
        FileObject fo = FileUtil.toFileObject((File)this.art.getFile());
        if (fo != null && !FileUtil.isArchiveFile((FileObject)fo)) {
            fo = null;
        }
        this.sourceExists.set(this.getSourceFile().exists());
        this.javadocExists.set(this.getJavadocFile().exists());
        this.fileObject.set(fo);
        this.setDisplayName(this.createName(this.longLiving));
        this.setIconBase(this.longLiving);
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
        if (this.longLiving && Children.LEAF == this.getChildren() && (childs = DependencyNode.createChildren(nodeDelegate = DependencyNode.createNodeDelegate(this.art, fo, true))) != Children.LEAF) {
            this.setChildren(childs);
            PathFinders.updateDelegate((PathFinder)this.getLookup().lookup(PathFinder.class), (PathFinder)nodeDelegate.getLookup().lookup(PathFinder.class));
        }
    }

    public String getHtmlDisplayName() {
        StringBuilder n = new StringBuilder("<html>");
        n.append(this.getDisplayName());
        if (ArtifactUtils.isSnapshot((String)this.art.getVersion()) && this.art.getVersion().indexOf("SNAPSHOT") < 0) {
            n.append(" <b>[").append(this.art.getVersion()).append("]</b>");
        }
        if (!this.art.getArtifactHandler().isAddedToClasspath() && !"compile".equals(this.art.getScope())) {
            n.append("  <i>[").append(this.art.getScope()).append("]</i>");
        }
        n.append("</html>");
        return n.toString();
    }

    private String createName(boolean longLiving) {
        Project prj;
        if (longLiving && (prj = this.getDependencyProjectAvailable()) != null) {
            return ProjectUtils.getInformation((Project)prj).getDisplayName();
        }
        if (NbArtifactFixer.isFallbackFile(this.art.getFile())) {
            return this.art.getArtifactId() + "-" + this.art.getBaseVersion() + (this.art.getClassifier() != null ? "-" + this.art.getClassifier() : "") + "." + this.art.getArtifactHandler().getExtension();
        }
        return this.art.getFile().getName();
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> acts = new ArrayList<Action>();
        if (this.longLiving && this.isDependencyProjectAvailable()) {
            acts.add(OpenProjectAction.SINGLETON);
        }
        if (this.isAddedToCP()) {
            InstallLocalArtifactAction act = new InstallLocalArtifactAction();
            acts.add(act);
            if (!this.isLocal()) {
                act.setEnabled(true);
            }
        }
        if (!this.hasJavadocInRepository()) {
            acts.add(new DownloadJavadocSrcAction(true));
            if (this.isAddedToCP()) {
                acts.add(new InstallLocalJavadocAction());
            }
        }
        if (!this.hasSourceInRepository()) {
            acts.add(new DownloadJavadocSrcAction(false));
            if (this.isAddedToCP()) {
                acts.add(new InstallLocalSourcesAction());
            }
        }
        if (this.isTransitive()) {
            acts.add(new ExcludeTransitiveAction());
            acts.add(SETINCURRENTINSTANCE);
        } else {
            acts.add(REMOVEDEPINSTANCE);
        }
        acts.add(null);
        acts.add(CommonArtifactActions.createViewArtifactDetails(this.art, this.project.getOriginalMavenProject().getRemoteArtifactRepositories()));
        acts.add(CommonArtifactActions.createFindUsages(this.art));
        acts.add(null);
        acts.add(CommonArtifactActions.createViewJavadocAction(this.art));
        acts.add(null);
        acts.add((Action)PropertiesAction.get(PropertiesAction.class));
        return acts.toArray(new Action[acts.size()]);
    }

    public boolean canDestroy() {
        return !this.isTransitive();
    }

    public void destroy() throws IOException {
        REMOVEDEPINSTANCE.createContextAwareInstance(this.getLookup()).actionPerformed(null);
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public boolean isLocal() {
        FileObject fo = this.fileObject.get();
        return fo != null && fo.isValid() && !NbArtifactFixer.isFallbackFile(this.art.getFile());
    }

    public boolean hasJavadocInRepository() {
        return this.javadocExists.get() && !"system".equals(this.art.getScope());
    }

    public File getJavadocFile() {
        File artifact = this.art.getFile();
        String version = artifact.getParentFile().getName();
        String artifactId = artifact.getParentFile().getParentFile().getName();
        return new File(artifact.getParentFile(), artifactId + "-" + version + (this.art.getClassifier() != null ? "-" + this.art.getClassifier() : "") + "-javadoc.jar");
    }

    public File getSourceFile() {
        File artifact = this.art.getFile();
        String version = artifact.getParentFile().getName();
        String artifactId = artifact.getParentFile().getParentFile().getName();
        return new File(artifact.getParentFile(), artifactId + "-" + version + (this.art.getClassifier() != null ? "-" + this.art.getClassifier() : "") + "-sources.jar");
    }

    public boolean hasSourceInRepository() {
        return this.sourceExists.get() && !"system".equals(this.art.getScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadJavadocSources(ProgressContributor progress, boolean isjavadoc) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        progress.start(2);
        if ("system".equals(this.art.getScope())) {
            progress.finish();
            return;
        }
        try {
            List<RepositoryForBinaryQueryImpl.Coordinates> coordinates;
            String bundleName;
            String classifier;
            if (isjavadoc) {
                classifier = "javadoc";
                bundleName = "MSG_Checking_Javadoc";
            } else {
                classifier = "sources";
                bundleName = "MSG_Checking_Sources";
            }
            Artifact sources = this.project.getEmbedder().createArtifactWithClassifier(this.art.getGroupId(), this.art.getArtifactId(), this.art.getVersion(), this.art.getType(), (this.art.getClassifier() != null ? this.art.getClassifier() + "-" : "") + classifier);
            progress.progress(NbBundle.getMessage(DependencyNode.class, (String)bundleName, (Object)this.art.getId()), 1);
            online.resolve(sources, this.project.getOriginalMavenProject().getRemoteArtifactRepositories(), this.project.getEmbedder().getLocalRepository());
            if (this.art.getFile() != null && this.art.getFile().exists() && (coordinates = RepositoryForBinaryQueryImpl.getShadedCoordinates(this.art.getFile())) != null) {
                for (RepositoryForBinaryQueryImpl.Coordinates coordinate : coordinates) {
                    sources = this.project.getEmbedder().createArtifactWithClassifier(coordinate.groupId, coordinate.artifactId, coordinate.version, "jar", classifier);
                    progress.progress(NbBundle.getMessage(DependencyNode.class, (String)bundleName, (Object)this.art.getId()), 1);
                    online.resolve(sources, this.project.getOriginalMavenProject().getRemoteArtifactRepositories(), this.project.getEmbedder().getLocalRepository());
                }
            }
        }
        catch (ArtifactNotFoundException ex) {
        }
        catch (ArtifactResolutionException ex) {
        }
        finally {
            progress.finish();
        }
        this.refreshNode();
    }

    public Image getIcon(int param) {
        return this.badge(super.getIcon(param));
    }

    private boolean isIconProjectBased() {
        String base = this.iconBase;
        return TRANSITIVE_MAVEN_ICON.equals(base) || MAVEN_ICON.equals(base);
    }

    private Image badge(Image retValue) {
        if (this.isLocal()) {
            Image ann;
            if (!this.isIconProjectBased()) {
                if (this.hasJavadocInRepository()) {
                    ann = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
                    ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipJavadoc);
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)0);
                }
                if (this.hasSourceInRepository()) {
                    ann = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
                    ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipSource);
                    retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)8);
                }
            }
            if (DependencyNode.showManagedState() && this.isManaged()) {
                ann = ImageUtilities.loadImage((String)MANAGED_BADGE_ICON);
                ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipManaged);
                retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)0, (int)8);
            }
            return retValue;
        }
        if (!this.isIconProjectBased()) {
            Image ann = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/brokenProjectBadge.png");
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipMissing);
            return ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)0, (int)0);
        }
        return retValue;
    }

    public Image getOpenedIcon(int type) {
        return this.badge(super.getOpenedIcon(type));
    }

    public Component getCustomizer() {
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set basicProps = sheet.get("properties");
        try {
            PropertySupport.Reflection artifactId = new PropertySupport.Reflection((Object)this.art, String.class, "getArtifactId", null);
            artifactId.setName("artifactId");
            artifactId.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Artifact"));
            artifactId.setShortDescription("");
            PropertySupport.Reflection groupId = new PropertySupport.Reflection((Object)this.art, String.class, "getGroupId", null);
            groupId.setName("groupId");
            groupId.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Group"));
            groupId.setShortDescription("");
            PropertySupport.Reflection version = new PropertySupport.Reflection((Object)this.art, String.class, "getVersion", null);
            version.setName("version");
            version.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Version"));
            version.setShortDescription(NbBundle.getMessage(DependencyNode.class, (String)"HINT_Version"));
            PropertySupport.Reflection type = new PropertySupport.Reflection((Object)this.art, String.class, "getType", null);
            type.setName("type");
            type.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Type"));
            PropertySupport.Reflection scope = new PropertySupport.Reflection((Object)this.art, String.class, "getScope", null);
            scope.setName("scope");
            scope.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Scope"));
            PropertySupport.Reflection classifier = new PropertySupport.Reflection((Object)this.art, String.class, "getClassifier", null);
            classifier.setName("classifier");
            classifier.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Classifier"));
            PropertySupport.Reflection hasJavadoc = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "hasJavadocInRepository", null);
            hasJavadoc.setName("javadoc");
            hasJavadoc.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Javadoc_Locally"));
            PropertySupport.Reflection hasSources = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "hasSourceInRepository", null);
            hasSources.setName("sources");
            hasSources.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Sources_Locally"));
            PropertySupport.Reflection transitive = new PropertySupport.Reflection((Object)this, Boolean.TYPE, "isTransitive", null);
            transitive.setName("transitive");
            transitive.setDisplayName(NbBundle.getMessage(DependencyNode.class, (String)"PROP_Transitive"));
            basicProps.put(new Node.Property[]{artifactId, groupId, version, type, scope, classifier, transitive, hasJavadoc, hasSources});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        return sheet;
    }

    private static boolean showManagedState() {
        return DependenciesNode.prefs().getBoolean(SHOW_MANAGED_DEPENDENCIES, false);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(SHOW_MANAGED_DEPENDENCIES)) {
            this.refreshNode();
        }
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(Bundle.BTN_Open_Project()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HashSet<Project> projects = new HashSet<Project>();
                    for (Artifact art : context.lookupAll(Artifact.class)) {
                        Project p;
                        File f = art.getFile();
                        if (f == null || (p = FileOwnerQuery.getOwner((URI)org.openide.util.Utilities.toURI((File)f))) == null) continue;
                        projects.add(p);
                    }
                    OpenProjects.getDefault().open((Project[])projects.toArray(new NbMavenProjectImpl[projects.size()]), false, true);
                }
            };
        }
    }

    private static class JarFilterNode
    extends FilterNode {
        JarFilterNode(Node original) {
            super(original, (Children)(FilterNode.Children.LEAF == original.getChildren() ? FilterNode.Children.LEAF : new JarContentFilterChildren(original)));
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> result = new ArrayList<Action>();
            result.addAll(Arrays.asList(super.getActions(false)));
            result.add(new OpenJavadocAction());
            return result.toArray(new Action[result.size()]);
        }

        private class OpenJavadocAction
        extends AbstractAction {
            private OpenJavadocAction() {
                this.putValue("Name", Bundle.BTN_View_Javadoc());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                URL javadocUrl;
                DataObject dobj = (DataObject)JarFilterNode.this.getOriginal().getLookup().lookup(DataObject.class);
                if (dobj == null) {
                    return;
                }
                FileObject fil = dobj.getPrimaryFile();
                FileObject jar = FileUtil.getArchiveFile((FileObject)fil);
                FileObject root = FileUtil.getArchiveRoot((FileObject)jar);
                String rel = FileUtil.getRelativePath((FileObject)root, (FileObject)fil);
                rel = rel.replaceAll("[.]class$", ".html");
                JavadocForBinaryQuery.Result res = JavadocForBinaryQuery.findJavadoc((URL)root.toURL());
                if (fil.isFolder()) {
                    rel = rel + "/package-summary.html";
                }
                if ((javadocUrl = this.findJavadoc(rel, res.getRoots())) != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(javadocUrl);
                } else {
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERR_No_Javadoc_Found(fil.getPath()));
                }
            }

            URL findJavadoc(String resource, URL[] urls) {
                for (int i = 0; i < urls.length; ++i) {
                    String base = urls[i].toExternalForm();
                    if (!base.endsWith("/")) {
                        base = base + "/";
                    }
                    try {
                        URL u = new URL(base + resource);
                        FileObject fo = URLMapper.findFileObject((URL)u);
                        if (fo == null) continue;
                        return u;
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }

    private static class JarContentFilterChildren
    extends FilterNode.Children {
        JarContentFilterChildren(Node orig) {
            super(orig);
        }

        protected Node copyNode(Node node) {
            return new JarFilterNode(node);
        }
    }

    private static class ArtifactSourceGroup
    implements SourceGroup {
        private Artifact art;

        public ArtifactSourceGroup(Artifact art) {
            this.art = art;
        }

        public FileObject getRootFolder() {
            FileObject fo = FileUtil.toFileObject((File)this.art.getFile());
            if (fo != null) {
                return FileUtil.getArchiveRoot((FileObject)fo);
            }
            return null;
        }

        public String getName() {
            return this.art.getId();
        }

        public String getDisplayName() {
            return this.art.getId();
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private class InstallLocalSourcesAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalSourcesAction() {
            this.putValue("Name", Bundle.BTN_Add_sources());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.source = InstallDocSourcePanel.showInstallDialog(false);
            if (this.source != null) {
                RP.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            File target = DependencyNode.this.getSourceFile();
            try {
                FileUtils.copyFile((File)this.source, (File)target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                target.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class InstallLocalJavadocAction
    extends AbstractAction
    implements Runnable {
        private File source;

        public InstallLocalJavadocAction() {
            this.putValue("Name", Bundle.BTN_Add_javadoc());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.source = InstallDocSourcePanel.showInstallDialog(true);
            if (this.source != null) {
                RP.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            File target = DependencyNode.this.getJavadocFile();
            try {
                FileUtils.copyFile((File)this.source, (File)target);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                target.delete();
            }
            DependencyNode.this.refreshNode();
        }
    }

    private class InstallLocalArtifactAction
    extends AbstractAction {
        public InstallLocalArtifactAction() {
            this.putValue("Name", Bundle.BTN_Manually_install());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File fil = InstallPanel.showInstallDialog(DependencyNode.this.art);
            if (fil != null) {
                InstallPanel.runInstallGoal(DependencyNode.this.project, fil, DependencyNode.this.art);
            }
        }
    }

    private static class SetInCurrentAction
    extends AbstractAction
    implements ContextAwareAction {
        private Lookup lkp;

        SetInCurrentAction(Lookup lookup) {
            this.putValue("Name", Bundle.BTN_Set_Dependency());
            this.lkp = lookup;
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                this.setEnabled(false);
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new SetInCurrentAction(actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            final Collection artifacts = this.lkp.lookupAll(Artifact.class);
            if (artifacts.isEmpty()) {
                return;
            }
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                return;
            }
            final NbMavenProjectImpl project = (NbMavenProjectImpl)prjs.iterator().next();
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (Artifact art : artifacts) {
                        Dependency dep = model.getProject().findDependencyById(art.getGroupId(), art.getArtifactId(), null);
                        if (dep == null) {
                            ArrayList<String> profileNames = new ArrayList<String>();
                            for (org.apache.maven.model.Profile prof : project.getOriginalMavenProject().getActiveProfiles()) {
                                profileNames.add(prof.getId());
                            }
                            for (String profileId : profileNames) {
                                Profile modProf = model.getProject().findProfileById(profileId);
                                if (modProf == null || (dep = modProf.findDependencyById(art.getGroupId(), art.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dep != null) continue;
                        dep = model.getFactory().createDependency();
                        dep.setArtifactId(art.getArtifactId());
                        dep.setGroupId(art.getGroupId());
                        dep.setType(art.getType());
                        dep.setVersion(art.getVersion());
                        if (!"compile".equals(art.getScope())) {
                            dep.setScope(art.getScope());
                        }
                        if (art.getClassifier() != null) {
                            dep.setClassifier(art.getClassifier());
                        }
                        model.getProject().addDependency(dep);
                    }
                }
            };
            RP.post(new Runnable((ModelOperation)operation){
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$operation = modelOperation;
                }

                @Override
                public void run() {
                    FileObject fo = FileUtil.toFileObject((File)project.getPOMFile());
                    Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(this.val$operation));
                }
            });
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        public DownloadJavadocSrcAction(boolean javadoc) {
            this.putValue("Name", javadoc ? Bundle.LBL_Download_Javadoc() : Bundle.LBL_Download__Sources());
            this.javadoc = javadoc;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressContributor contributor = AggregateProgressFactory.createProgressContributor((String)"multi-1");
                    String label = DownloadJavadocSrcAction.this.javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                    AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)label, (ProgressContributor[])new ProgressContributor[]{contributor}, (Cancellable)ProgressTransferListener.cancellable(), null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        if (DownloadJavadocSrcAction.this.javadoc && !DependencyNode.this.hasJavadocInRepository()) {
                            DependencyNode.this.downloadJavadocSources(contributor, DownloadJavadocSrcAction.this.javadoc);
                        } else if (!DownloadJavadocSrcAction.this.javadoc && !DependencyNode.this.hasSourceInRepository()) {
                            DependencyNode.this.downloadJavadocSources(contributor, DownloadJavadocSrcAction.this.javadoc);
                        } else {
                            contributor.finish();
                        }
                    }
                    catch (ThreadDeath d) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private class ExcludeTransitiveAction
    extends AbstractAction {
        public ExcludeTransitiveAction() {
            this.putValue("Name", Bundle.BTN_Exclude_Dependency());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            RP.post(new Runnable(){

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    void var4_9;
                    org.apache.maven.shared.dependency.tree.DependencyNode rootnode = DependencyTreeFactory.createDependencyTree((MavenProject)DependencyNode.this.project.getOriginalMavenProject(), (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (String)"test");
                    DependencyExcludeNodeVisitor nv = new DependencyExcludeNodeVisitor(DependencyNode.this.art.getGroupId(), DependencyNode.this.art.getArtifactId(), DependencyNode.this.art.getType());
                    rootnode.accept((DependencyNodeVisitor)nv);
                    Set<org.apache.maven.shared.dependency.tree.DependencyNode> nds = nv.getDirectDependencies();
                    if (nds.size() > 1) {
                        ExcludeDependencyPanel pnl = new ExcludeDependencyPanel(DependencyNode.this.project.getOriginalMavenProject(), DependencyNode.this.art, nds, rootnode);
                        DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Exclude());
                        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (ret != DialogDescriptor.OK_OPTION) return;
                        Collection collection = pnl.getDependencyExcludes().get(DependencyNode.this.art);
                    } else {
                        Set<org.apache.maven.shared.dependency.tree.DependencyNode> set = nds;
                    }
                    ExcludeTransitiveAction.this.runModifyExclusions(DependencyNode.this.art, (Collection)var4_9);
                }
            });
        }

        private void runModifyExclusions(final Artifact art, final Collection<org.apache.maven.shared.dependency.tree.DependencyNode> nds) {
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (org.apache.maven.shared.dependency.tree.DependencyNode nd : nds) {
                        Exclusion ex;
                        Artifact directArt = nd.getArtifact();
                        Dependency dep = model.getProject().findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null);
                        if (dep == null) {
                            ArrayList<String> profileNames = new ArrayList<String>();
                            for (org.apache.maven.model.Profile prof : DependencyNode.this.project.getOriginalMavenProject().getActiveProfiles()) {
                                profileNames.add(prof.getId());
                            }
                            for (String profileId : profileNames) {
                                Profile modProf = model.getProject().findProfileById(profileId);
                                if (modProf == null || (dep = modProf.findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dep == null) {
                            dep = model.getFactory().createDependency();
                            dep.setArtifactId(directArt.getArtifactId());
                            dep.setGroupId(directArt.getGroupId());
                            dep.setType(directArt.getType());
                            dep.setVersion(directArt.getVersion());
                            model.getProject().addDependency(dep);
                        }
                        if ((ex = dep.findExclusionById(art.getGroupId(), art.getArtifactId())) != null) continue;
                        Exclusion exclude = model.getFactory().createExclusion();
                        exclude.setArtifactId(art.getArtifactId());
                        exclude.setGroupId(art.getGroupId());
                        dep.addExclusion(exclude);
                    }
                }
            };
            FileObject fo = FileUtil.toFileObject((File)DependencyNode.this.project.getPOMFile());
            Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
        }
    }

    static class ShowManagedStateAction
    extends AbstractAction
    implements Presenter.Popup {
        ShowManagedStateAction() {
            String s = Bundle.LBL_ShowManagedState();
            this.putValue("Name", s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DependenciesNode.prefs().putBoolean(DependencyNode.SHOW_MANAGED_DEPENDENCIES, !DependencyNode.showManagedState());
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(this);
            mi.setSelected(DependencyNode.showManagedState());
            return mi;
        }
    }

    private static class RemoveDependencyAction
    extends AbstractAction
    implements ContextAwareAction {
        private Lookup lkp;

        RemoveDependencyAction(Lookup look) {
            this.putValue("Name", Bundle.BTN_Remove_Dependency());
            this.lkp = look;
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                this.setEnabled(false);
            }
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new RemoveDependencyAction(actionContext);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            final Collection artifacts = this.lkp.lookupAll(Artifact.class);
            if (artifacts.isEmpty()) {
                return;
            }
            Collection res = this.lkp.lookupAll(NbMavenProjectImpl.class);
            HashSet prjs = new HashSet(res);
            if (prjs.size() != 1) {
                return;
            }
            final NbMavenProjectImpl project = (NbMavenProjectImpl)prjs.iterator().next();
            final ArrayList unremoved = new ArrayList();
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    for (Artifact art : artifacts) {
                        Dependency dep = model.getProject().findDependencyById(art.getGroupId(), art.getArtifactId(), null);
                        if (dep != null) {
                            model.getProject().removeDependency(dep);
                            continue;
                        }
                        unremoved.add(art);
                    }
                }
            };
            RP.post(new Runnable((ModelOperation)operation, unremoved){
                final /* synthetic */ ModelOperation val$operation;
                final /* synthetic */ List val$unremoved;
                {
                    this.val$operation = modelOperation;
                    this.val$unremoved = list;
                }

                @Override
                public void run() {
                    FileObject fo = FileUtil.toFileObject((File)project.getPOMFile());
                    Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(this.val$operation));
                    if (this.val$unremoved.size() > 0) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyNode.class, (String)"MSG_Located_In_Parent", (Object)this.val$unremoved.size()), Integer.MAX_VALUE);
                    }
                }
            });
        }
    }
}

