/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.modelcache;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.modelcache.ActiveConfigurationProvider;
import org.netbeans.modules.maven.modelcache.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class MavenProjectCache {
    private static final Logger LOG = Logger.getLogger(MavenProjectCache.class.getName());
    private static final String CONTEXT_EXECUTION_RESULT = "NB_Execution_Result";
    private static final String CONTEXT_PARTICIPANTS = "NB_AbstractParticipant_Present";
    private static final Map<FileObject, WeakReference<MavenProject>> file2Project = new WeakHashMap<FileObject, WeakReference<MavenProject>>();
    private static final Map<FileObject, Mutex> file2Mutex = new WeakHashMap<FileObject, Mutex>();
    private static final Properties statics = new Properties();

    public static MavenProject getMavenProject(final FileObject projectDirectory, final boolean reload) {
        if (projectDirectory.getFileObject("pom.xml") == null) {
            return null;
        }
        Mutex mutex = MavenProjectCache.getMutex(projectDirectory);
        MavenProject mp = (MavenProject)mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                MavenProject mp;
                WeakReference ref;
                if (!reload && (ref = (WeakReference)file2Project.get(projectDirectory)) != null && (mp = (MavenProject)ref.get()) != null) {
                    return mp;
                }
                MavenProject mp2 = MavenProjectCache.loadOriginalMavenProject(projectDirectory);
                file2Project.put(projectDirectory, new WeakReference<MavenProject>(mp2));
                return mp2;
            }
        });
        return mp;
    }

    public static MavenExecutionResult getExecutionResult(MavenProject project) {
        return (MavenExecutionResult)project.getContextValue(CONTEXT_EXECUTION_RESULT);
    }

    public static boolean unknownBuildParticipantObserved(MavenProject project) {
        return project.getContextValue(CONTEXT_PARTICIPANTS) != null;
    }

    public static Collection<String> getUnknownBuildParticipantsClassNames(MavenProject project) {
        return (Collection)project.getContextValue(CONTEXT_PARTICIPANTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static MavenProject loadOriginalMavenProject(FileObject projectDirectory) {
        DefaultMavenExecutionResult res;
        MavenProject newproject;
        long startLoading;
        block17: {
            startLoading = System.currentTimeMillis();
            MavenEmbedder projectEmbedder = EmbedderFactory.getProjectEmbedder();
            newproject = null;
            M2AuxilaryConfigImpl aux = new M2AuxilaryConfigImpl(projectDirectory, false);
            ActiveConfigurationProvider config = new ActiveConfigurationProvider(projectDirectory, aux);
            M2Configuration active = config.getActiveConfiguration();
            File pomFile = new File(FileUtil.toFile((FileObject)projectDirectory), "pom.xml");
            res = null;
            try {
                ClassRealm projectRealm;
                MavenExecutionRequest req = projectEmbedder.createMavenExecutionRequest();
                req.addActiveProfiles(active.getActivatedProfiles());
                req.setPom(pomFile);
                req.setNoSnapshotUpdates(true);
                req.setUpdateSnapshots(false);
                req.setInteractiveMode(false);
                req.setRecursive(false);
                req.setOffline(true);
                req.setUserProperties(MavenProjectCache.createSystemPropsForProjectLoading(active.getProperties()));
                res = projectEmbedder.readProjectWithDependencies(req, true);
                newproject = res.getProject();
                if (newproject != null && (projectRealm = newproject.getClassRealm()) != null) {
                    ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                    try {
                        List lookup = projectEmbedder.getPlexus().lookupList(AbstractMavenLifecycleParticipant.class);
                        if (lookup.size() > 0) {
                            ArrayList<String> parts = new ArrayList<String>();
                            for (AbstractMavenLifecycleParticipant part : lookup) {
                                parts.add(part.getClass().getName());
                            }
                            newproject.setContextValue(CONTEXT_PARTICIPANTS, parts);
                        }
                    }
                    catch (ComponentLookupException e) {
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                    }
                }
                if (newproject != null) break block17;
            }
            catch (RuntimeException exc) {
                block18: {
                    try {
                        LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + projectDirectory, exc);
                        res = new DefaultMavenExecutionResult();
                        res.addException((Throwable)exc);
                        if (newproject != null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (newproject == null) {
                            newproject = MavenProjectCache.getFallbackProject(pomFile);
                        }
                        newproject.setProjectBuildingRequest(null);
                        newproject.setContextValue(CONTEXT_EXECUTION_RESULT, res);
                        long endLoading = System.currentTimeMillis();
                        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
                        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                            LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                        }
                        throw throwable;
                    }
                    newproject = MavenProjectCache.getFallbackProject(pomFile);
                }
                newproject.setProjectBuildingRequest(null);
                newproject.setContextValue(CONTEXT_EXECUTION_RESULT, (Object)res);
                long endLoading = System.currentTimeMillis();
                LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
                if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                    LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                }
            }
            newproject = MavenProjectCache.getFallbackProject(pomFile);
        }
        newproject.setProjectBuildingRequest(null);
        newproject.setContextValue(CONTEXT_EXECUTION_RESULT, (Object)res);
        long endLoading = System.currentTimeMillis();
        LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
        if (LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
        }
        return newproject;
    }

    public static MavenProject getFallbackProject(File projectFile) throws AssertionError {
        MavenProject newproject = new MavenProject();
        newproject.setGroupId("error");
        newproject.setArtifactId("error");
        newproject.setVersion("0");
        newproject.setPackaging("pom");
        newproject.setName(Bundle.LBL_Incomplete_Project_Name());
        newproject.setDescription(Bundle.LBL_Incomplete_Project_Desc());
        newproject.setFile(projectFile);
        return newproject;
    }

    public static boolean isFallbackproject(MavenProject prj) {
        return "error".equals(prj.getGroupId()) && "error".equals(prj.getArtifactId()) && Bundle.LBL_Incomplete_Project_Name().equals(prj.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties cloneStaticProps() {
        Properties properties = statics;
        synchronized (properties) {
            if (statics.isEmpty()) {
                statics.setProperty("netbeans.execution", "true");
                EmbedderFactory.fillEnvVars((Properties)statics);
                statics.putAll((Map<?, ?>)AbstractMavenExecutor.excludeNetBeansProperties(System.getProperties()));
            }
            Properties toRet = new Properties();
            toRet.putAll((Map<?, ?>)statics);
            return toRet;
        }
    }

    public static Properties createSystemPropsForProjectLoading(Map<String, String> activeConfiguration) {
        Properties props = MavenProjectCache.cloneStaticProps();
        if (activeConfiguration != null) {
            props.putAll(activeConfiguration);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getMutex(FileObject projectDirectory) {
        Map<FileObject, Mutex> map = file2Mutex;
        synchronized (map) {
            Mutex mutex = file2Mutex.get(projectDirectory);
            if (mutex != null) {
                return mutex;
            }
            mutex = new Mutex();
            file2Mutex.put(projectDirectory, mutex);
            return mutex;
        }
    }
}

