/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class DefaultReplaceTokenProvider
implements ReplaceTokenProvider,
ActionConvertor {
    private static final String ARTIFACTID = "artifactId";
    private static final String CLASSPATHSCOPE = "classPathScope";
    private static final String GROUPID = "groupId";
    private final Project project;
    static final String CLASSNAME = "className";
    static final String CLASSNAME_EXT = "classNameWithExtension";
    static final String PACK_CLASSNAME = "packageClassName";
    public static final String METHOD_NAME = "nb.single.run.methodName";
    private static final String VARIABLE_PREFIX = "var.";

    public DefaultReplaceTokenProvider(Project prj) {
        this.project = prj;
    }

    private static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        Collection methods;
        ArrayList<FileObject> files = new ArrayList<FileObject>(lookup.lookupAll(FileObject.class));
        if (files.isEmpty()) {
            for (DataObject d : lookup.lookupAll(DataObject.class)) {
                files.add(d.getPrimaryFile());
            }
        }
        if ((methods = lookup.lookupAll(SingleMethod.class)).size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    @Override
    public Map<String, String> createReplacements(String actionName, Lookup lookup) {
        String withExt;
        Collection methods;
        FileObject[] fos = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup);
        SourceGroup group = DefaultReplaceTokenProvider.findGroup(ProjectUtils.getSources((Project)this.project).getSourceGroups("java"), fos);
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            replaceMap.put("Env." + entry.getKey(), entry.getValue());
        }
        Map<String, String> vars = DefaultReplaceTokenProvider.readVariables();
        replaceMap.putAll(vars);
        Map<String, String> configProps = ((M2ConfigProvider)this.project.getLookup().lookup(M2ConfigProvider.class)).getActiveConfiguration().getProperties();
        replaceMap.putAll(configProps);
        NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        replaceMap.put(GROUPID, prj.getMavenProject().getGroupId());
        replaceMap.put(ARTIFACTID, prj.getMavenProject().getArtifactId());
        StringBuilder packClassname = new StringBuilder();
        StringBuilder classname = new StringBuilder();
        StringBuilder classnameExt = new StringBuilder();
        if (group != null) {
            boolean first = true;
            boolean isTest = false;
            HashSet<String> uniqueClassNames = new HashSet<String>(fos.length);
            for (FileObject file : fos) {
                if (first) {
                    first = false;
                } else {
                    if (!isTest && !"test.single".equals(actionName) && !"debug.test.single".equals(actionName) && !"profile.test.single".equals(actionName) && !"test".equals(actionName)) break;
                    isTest = true;
                    packClassname.append(',');
                    classname.append(',');
                    classnameExt.append(',');
                }
                if (file.isFolder()) {
                    String rel = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)file);
                    assert (rel != null);
                    String pkg = rel.replace('/', '.');
                    if (!pkg.isEmpty()) {
                        packClassname.append(pkg).append('.');
                    }
                    packClassname.append("*");
                    if ("test.single".equals(actionName) || "debug.test.single".equals(actionName)) {
                        packClassname.append("Test");
                    }
                    classname.append(pkg);
                    classnameExt.append(pkg);
                    continue;
                }
                String relP = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)file.getParent());
                assert (relP != null);
                StringBuilder cn = new StringBuilder();
                if (!relP.isEmpty()) {
                    cn.append(relP.replace('/', '.')).append('.');
                }
                String n = file.getName();
                cn.append(n);
                if (uniqueClassNames.add(cn.toString())) {
                    packClassname.append((CharSequence)cn);
                    classname.append(n);
                } else {
                    packClassname.deleteCharAt(packClassname.length() - 1);
                    classname.deleteCharAt(classname.length() - 1);
                }
                classnameExt.append(file.getNameExt());
            }
        }
        if (packClassname.length() > 0) {
            replaceMap.put(PACK_CLASSNAME, packClassname.toString());
        }
        if (classname.length() > 0) {
            replaceMap.put(CLASSNAME, classname.toString());
        }
        if (classnameExt.length() > 0) {
            replaceMap.put(CLASSNAME_EXT, classnameExt.toString());
        }
        if ((methods = lookup.lookupAll(SingleMethod.class)).size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            replaceMap.put(METHOD_NAME, method.getMethodName());
        }
        if (group != null && "2TestSourceRoot".equals(group.getName())) {
            replaceMap.put(CLASSPATHSCOPE, "test");
        } else {
            replaceMap.put(CLASSPATHSCOPE, "runtime");
        }
        if (group != null && "1SourceRoot".equals(group.getName()) && ("test.single".equals(actionName) || "debug.test.single".equals(actionName)) && (withExt = replaceMap.get(CLASSNAME_EXT)) != null && withExt.endsWith(".java")) {
            replaceMap.put(CLASSNAME_EXT, withExt.replace(".java", "Test.java"));
            replaceMap.put(CLASSNAME, replaceMap.get(CLASSNAME) + "Test");
            replaceMap.put(PACK_CLASSNAME, replaceMap.get(PACK_CLASSNAME) + "Test");
        }
        return replaceMap;
    }

    @CheckForNull
    private static SourceGroup findGroup(SourceGroup[] groups, FileObject[] files) {
        SourceGroup selected = null;
        for (FileObject file : files) {
            for (SourceGroup group : groups) {
                FileObject root = group.getRootFolder();
                if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                if (selected == null) {
                    selected = group;
                    continue;
                }
                if (selected == group) continue;
                return null;
            }
        }
        return selected;
    }

    public static Map<String, String> readVariables() {
        HashMap<String, String> vs = new HashMap<String, String>();
        EditableProperties ep = PropertyUtils.getGlobalProperties();
        for (Map.Entry entry : ep.entrySet()) {
            if (!((String)entry.getKey()).startsWith(VARIABLE_PREFIX)) continue;
            vs.put(((String)entry.getKey()).substring(VARIABLE_PREFIX.length()), FileUtil.normalizeFile((File)new File((String)entry.getValue())).getAbsolutePath());
        }
        return vs;
    }

    @Override
    public String convert(String action, Lookup lookup) {
        FileObject fo;
        FileObject[] fos;
        if ("debug.single.method".equals(action)) {
            return "debug.test.single";
        }
        if ("run.single.method".equals(action)) {
            return "test.single";
        }
        if (("run.single".equals(action) || "debug.single".equals(action) || "profile.single".equals(action)) && (fos = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup)).length > 0 && "text/x-java".equals((fo = fos[0]).getMIMEType())) {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] grp = srcs.getSourceGroups("java");
            for (int i = 0; i < grp.length; ++i) {
                String relPath = FileUtil.getRelativePath((FileObject)grp[i].getRootFolder(), (FileObject)fo);
                if (relPath == null || !SourceUtils.isMainClass((String)relPath.replaceFirst("[.]java$", "").replace('/', '.'), (ClasspathInfo)ClasspathInfo.create((FileObject)fo), (boolean)true)) continue;
                return action + ".main";
            }
        }
        return null;
    }
}

