/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.spi.debug.AdditionalDebuggedProjects;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class Utils {
    private Utils() {
    }

    static MethodBreakpoint createBreakpoint(String stopClassName) {
        MethodBreakpoint breakpoint = MethodBreakpoint.create((String)stopClassName, (String)"*");
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return breakpoint;
    }

    public static File[] convertStringsToNormalizedFiles(Collection<String> strings) {
        File[] fos = new File[strings.size()];
        int index = 0;
        for (String str : strings) {
            fos[index] = FileUtilities.convertStringToFile(str);
            ++index;
        }
        return fos;
    }

    private static Set<String> collectClasspaths(Project prj) throws DependencyResolutionRequiredException {
        HashSet<String> toRet = new HashSet<String>();
        NbMavenProject watcher = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        MavenProject mproject = watcher.getMavenProject();
        toRet.addAll(mproject.getTestClasspathElements());
        boolean isPom = "pom".equals(watcher.getPackagingType());
        if (isPom) {
            SubprojectProvider subs = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
            Set subProjects = subs.getSubprojects();
            for (Project pr : subProjects) {
                toRet.addAll(Utils.collectClasspaths(pr));
            }
        }
        return toRet;
    }

    private static Set<String> collectSourceRoots(Project prj) {
        HashSet<String> toRet = new HashSet<String>();
        NbMavenProject watcher = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        MavenProject mproject = watcher.getMavenProject();
        toRet.addAll(mproject.getTestCompileSourceRoots());
        boolean isPom = "pom".equals(watcher.getPackagingType());
        if (isPom) {
            SubprojectProvider subs = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
            Set subProjects = subs.getSubprojects();
            for (Project pr : subProjects) {
                toRet.addAll(Utils.collectSourceRoots(pr));
            }
        }
        return toRet;
    }

    static ClassPath createSourcePath(Project project) {
        ClassPath cp;
        File[] roots;
        AdditionalDebuggedProjects adds;
        Set<String> col;
        try {
            col = Utils.collectClasspaths(project);
            adds = (AdditionalDebuggedProjects)project.getLookup().lookup(AdditionalDebuggedProjects.class);
            if (adds != null) {
                for (Project prj : adds.getProjects()) {
                    col.addAll(Utils.collectClasspaths(prj));
                }
            }
            col.remove(null);
            roots = Utils.convertStringsToNormalizedFiles(col);
            cp = Utils.convertToSourcePath(roots);
        }
        catch (DependencyResolutionRequiredException ex) {
            ex.printStackTrace();
            cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        }
        col = Utils.collectSourceRoots(project);
        adds = (AdditionalDebuggedProjects)project.getLookup().lookup(AdditionalDebuggedProjects.class);
        if (adds != null) {
            for (Project prj : adds.getProjects()) {
                col.addAll(Utils.collectSourceRoots(prj));
            }
        }
        roots = Utils.convertStringsToNormalizedFiles(col);
        ClassPath sp = Utils.convertToClassPath(roots);
        ClassPath sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, sp});
        return sourcePath;
    }

    static ClassPath createJDKSourcePath(Project nbproject) {
        String val = ((AuxiliaryProperties)nbproject.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        JavaPlatform jp = BootClassPathImpl.getActivePlatform(val);
        if (jp == null) {
            jp = JavaPlatformManager.getDefault().getDefaultPlatform();
        }
        return jp.getSourceFolders();
    }

    private static ClassPath convertToClassPath(File[] roots) {
        ArrayList<URL> l = new ArrayList<URL>();
        for (int i = 0; i < roots.length; ++i) {
            URL url = Utils.fileToURL(roots[i]);
            l.add(url);
        }
        URL[] urls = l.toArray(new URL[l.size()]);
        return ClassPathSupport.createClassPath((URL[])urls);
    }

    private static ClassPath convertToSourcePath(File[] fs) {
        ArrayList<PathResourceImplementation> lst = new ArrayList<PathResourceImplementation>();
        HashSet<URL> existingSrc = new HashSet<URL>();
        for (int i = 0; i < fs.length; ++i) {
            URL url = Utils.fileToURL(fs[i]);
            try {
                FileObject[] srcfos = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
                for (int j = 0; j < srcfos.length; ++j) {
                    block7: {
                        if (FileUtil.isArchiveFile((FileObject)srcfos[j])) {
                            srcfos[j] = FileUtil.getArchiveRoot((FileObject)srcfos[j]);
                        }
                        try {
                            url = srcfos[j].toURL();
                            if (url.toExternalForm().endsWith("/")) break block7;
                            url = new URL(url.toExternalForm() + "/");
                        }
                        catch (MalformedURLException ex) {
                            ErrorManager.getDefault().notify(4096, (Throwable)ex);
                            continue;
                        }
                    }
                    if (url == null || existingSrc.contains(url)) continue;
                    lst.add(ClassPathSupport.createResource((URL)url));
                    existingSrc.add(url);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return ClassPathSupport.createClassPath(lst);
    }

    static URL fileToURL(File file) {
        try {
            URL url = Utilities.toURI((File)file).toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            }
            if (!url.toExternalForm().endsWith("/")) {
                url = new URL(url.toExternalForm() + "/");
            }
            return url;
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return null;
        }
    }
}

