/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel {
    private String oldEncoding;
    private String encoding;
    private final String sourceEncoding;
    private String defaultEncoding;
    private String sourceLevel;
    private ModelHandle2 handle;
    private ModelOperation<POMModel> sourceLevelOperation = new ModelOperation<POMModel>(){

        public void performOperation(POMModel model) {
            ModelUtils.setSourceLevel(model, SourcesPanel.this.sourceLevel);
        }
    };
    private ModelOperation<POMModel> encodingOperation = new ModelOperation<POMModel>(){

        public void performOperation(POMModel model) {
            boolean updateResources;
            boolean updateCompiler;
            POMComponentFactory fact = model.getFactory();
            Properties props = model.getProject().getProperties();
            if (props == null) {
                props = fact.createProperties();
                model.getProject().setProperties(props);
            }
            props.setProperty("project.build.sourceEncoding", SourcesPanel.this.encoding);
            boolean createPlugins = SourcesPanel.this.sourceEncoding == null;
            Build bld = model.getProject().getBuild();
            if (bld == null) {
                if (createPlugins) {
                    bld = fact.createBuild();
                    model.getProject().setBuild(bld);
                } else {
                    return;
                }
            }
            Plugin plugin = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
            Plugin plugin2 = bld.findPluginById("org.apache.maven.plugins", "maven-resources-plugin");
            String compilesource = PluginPropertyUtils.getPluginProperty(SourcesPanel.this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "encoding", null);
            String resourcesource = PluginPropertyUtils.getPluginProperty(SourcesPanel.this.handle.getProject(), "org.apache.maven.plugins", "maven-resources-plugin", "encoding", null);
            boolean bl = updateCompiler = createPlugins || compilesource != null;
            if (plugin == null && updateCompiler) {
                plugin = fact.createPlugin();
                plugin.setGroupId("org.apache.maven.plugins");
                plugin.setArtifactId("maven-compiler-plugin");
                plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
                bld.addPlugin(plugin);
            }
            if (plugin != null) {
                Configuration conf = plugin.getConfiguration();
                if (conf == null && updateCompiler) {
                    conf = fact.createConfiguration();
                    plugin.setConfiguration(conf);
                }
                if (conf != null && updateCompiler) {
                    conf.setSimpleParameter("encoding", "${project.build.sourceEncoding}");
                }
            }
            boolean bl2 = updateResources = createPlugins || resourcesource != null;
            if (plugin2 == null && updateResources) {
                plugin2 = fact.createPlugin();
                plugin2.setGroupId("org.apache.maven.plugins");
                plugin2.setArtifactId("maven-resources-plugin");
                plugin2.setVersion(MavenVersionSettings.getDefault().getVersion("maven-resources-plugin"));
                bld.addPlugin(plugin2);
            }
            if (plugin2 != null) {
                Configuration conf = plugin2.getConfiguration();
                if (conf == null && updateResources) {
                    conf = fact.createConfiguration();
                    plugin2.setConfiguration(conf);
                }
                if (conf != null && updateResources) {
                    conf.setSimpleParameter("encoding", "${project.build.sourceEncoding}");
                }
            }
        }
    };
    private JComboBox comEncoding;
    private JComboBox comSourceLevel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblEncoding;
    private JLabel lblGenerated;
    private JLabel lblProjectFolder;
    private JLabel lblSourceLevel;
    private JLabel lblSrc;
    private JLabel lblTestSrc;
    private JTextField txtProjectFolder;
    private JTextField txtSrc;
    private JTextField txtTestSrc;

    public SourcesPanel(ModelHandle2 handle, NbMavenProjectImpl project) {
        this.initComponents();
        this.handle = handle;
        FileObject projectFolder = project.getProjectDirectory();
        File pf = FileUtil.toFile((FileObject)projectFolder);
        this.txtProjectFolder.setText(pf == null ? "" : pf.getPath());
        this.comSourceLevel.setEditable(false);
        this.sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)project.getProjectDirectory());
        this.comSourceLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"1.3", "1.4", "1.5", "1.6", "1.7"}));
        this.comSourceLevel.setSelectedItem(this.sourceLevel);
        String enc = project.getOriginalMavenProject().getProperties().getProperty("project.build.sourceEncoding");
        if (enc == null) {
            enc = PluginPropertyUtils.getPluginProperty(project, "org.apache.maven.plugins", "maven-compiler-plugin", "encoding", null, "project.build.sourceEncoding");
        }
        this.oldEncoding = enc;
        if (enc != null) {
            try {
                Charset chs = Charset.forName(enc);
                this.oldEncoding = chs.name();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + enc);
            }
        }
        this.defaultEncoding = Charset.defaultCharset().toString();
        if (this.oldEncoding == null) {
            this.oldEncoding = this.defaultEncoding;
        }
        this.sourceEncoding = handle.getProject().getProperties().getProperty("project.build.sourceEncoding");
        this.comEncoding.setModel(ProjectCustomizer.encodingModel((String)this.oldEncoding));
        this.comEncoding.setRenderer(ProjectCustomizer.encodingRenderer());
        this.comSourceLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesPanel.this.handleSourceLevelChange();
            }
        });
        this.comEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesPanel.this.handleEncodingChange();
            }
        });
        this.txtSrc.setText(handle.getProject().getBuild().getSourceDirectory());
        this.txtTestSrc.setText(handle.getProject().getBuild().getTestSourceDirectory());
    }

    private void handleSourceLevelChange() {
        this.sourceLevel = (String)this.comSourceLevel.getSelectedItem();
        this.handle.removePOMModification(this.sourceLevelOperation);
        String source = PluginPropertyUtils.getPluginProperty(this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "source", "compile");
        if (source != null && source.contains(this.sourceLevel)) {
            return;
        }
        this.handle.addPOMModification(this.sourceLevelOperation);
    }

    private void handleEncodingChange() {
        Charset enc = (Charset)this.comEncoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.oldEncoding;
        this.encoding = encName;
        this.handle.removePOMModification(this.encodingOperation);
        if (!this.encoding.equals(this.sourceEncoding)) {
            this.handle.addPOMModification(this.encodingOperation);
        }
        if (this.defaultEncoding.equals(encName)) {
            this.lblEncoding.setFont(this.lblEncoding.getFont().deriveFont(0));
        } else {
            this.lblEncoding.setFont(this.lblEncoding.getFont().deriveFont(1));
        }
    }

    private void initComponents() {
        this.lblProjectFolder = new JLabel();
        this.txtProjectFolder = new JTextField();
        this.lblSrc = new JLabel();
        this.txtSrc = new JTextField();
        this.lblTestSrc = new JLabel();
        this.txtTestSrc = new JTextField();
        this.lblGenerated = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblSourceLevel = new JLabel();
        this.comSourceLevel = new JComboBox();
        this.lblEncoding = new JLabel();
        this.comEncoding = new JComboBox();
        this.jPanel2 = new JPanel();
        this.lblProjectFolder.setLabelFor(this.txtProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblProjectFolder, (String)NbBundle.getBundle(SourcesPanel.class).getString("CTL_ProjectFolder"));
        this.txtProjectFolder.setEditable(false);
        this.lblSrc.setLabelFor(this.txtSrc);
        Mnemonics.setLocalizedText((JLabel)this.lblSrc, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblSrc.text"));
        this.txtSrc.setEditable(false);
        this.lblTestSrc.setLabelFor(this.txtTestSrc);
        Mnemonics.setLocalizedText((JLabel)this.lblTestSrc, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblTestSrc.text"));
        this.txtTestSrc.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblGenerated, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblGenerated.text"));
        this.lblGenerated.setVerticalAlignment(1);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblSourceLevel.setLabelFor(this.comSourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.lblSourceLevel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"TXT_SourceLevel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel1.add((Component)this.lblSourceLevel, gridBagConstraints);
        this.comSourceLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"1.4", "1.5"}));
        this.comSourceLevel.setMinimumSize(this.comSourceLevel.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.comSourceLevel, gridBagConstraints);
        this.comSourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SourcesPanel.class).getString("AN_SourceLevel"));
        this.comSourceLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.comSourceLevel.AccessibleContext.accessibleDescription"));
        this.lblEncoding.setLabelFor(this.comEncoding);
        Mnemonics.setLocalizedText((JLabel)this.lblEncoding, (String)NbBundle.getMessage(SourcesPanel.class, (String)"TXT_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.jPanel1.add((Component)this.lblEncoding, gridBagConstraints);
        this.comEncoding.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.comEncoding, gridBagConstraints);
        this.comEncoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.comEncoding.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 617, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblProjectFolder).addComponent(this.lblSrc).addComponent(this.lblTestSrc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtTestSrc, -1, 519, Short.MAX_VALUE).addComponent(this.txtSrc, -1, 519, Short.MAX_VALUE).addComponent(this.txtProjectFolder, -1, 519, Short.MAX_VALUE))).addComponent(this.lblGenerated, -1, 617, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProjectFolder).addComponent(this.txtProjectFolder, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSrc).addComponent(this.txtSrc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTestSrc).addComponent(this.txtTestSrc, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblGenerated, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
        this.txtProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtProjectFolder.AccessibleContext.accessibleDescription"));
        this.txtSrc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtSrc.AccessibleContext.accessibleDescription"));
        this.txtTestSrc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtTestSrc.AccessibleContext.accessibleDescription"));
    }
}

