/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.cos.Bundle;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.modules.maven.spi.cos.CompileOnSaveSkipper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class CosChecker
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    static final String NB_COS = ".netbeans_automatic_build";
    private static final String STARTUP_ARGS_KEY = "run.jvmargs.ide";
    private static final String RUN_MAIN = "run.single.main";
    private static final String DEBUG_MAIN = "debug.single.main";
    private static final String PROFILE_MAIN = "profile.single.main";
    private static final Logger LOG = Logger.getLogger(CosChecker.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(CosChecker.class);
    private static final String SUGGESTION = "org/netbeans/modules/maven/resources/suggestion.png";
    private static boolean warnedNoCoS;
    private static boolean warnedCoS;

    @Override
    public boolean checkRunConfig(RunConfig config) {
        if (config.getProject() == null) {
            return true;
        }
        if (!this.checkRunMainClass(config)) {
            return false;
        }
        return this.checkRunTest(config);
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        if (!"build".equals(config.getActionName()) && !"rebuild".equals(config.getActionName())) {
            Project[] opened;
            for (Project openprj : opened = OpenProjects.getDefault().getOpenProjects()) {
                CosChecker.touchProject(openprj);
            }
        }
        return true;
    }

    private boolean checkRunMainClass(final RunConfig config) {
        String actionName = config.getActionName();
        if (RunUtils.hasApplicationCompileOnSaveEnabled(config) && ("jar".equals(((NbMavenProject)config.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()) && ("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName)) || RUN_MAIN.equals(actionName) || DEBUG_MAIN.equals(actionName) || PROFILE_MAIN.equals(actionName))) {
            String action2Quick;
            boolean supported;
            long stamp = CosChecker.getLastCoSLastTouch(config, false);
            if (this.checkImportantFiles(stamp, config)) {
                return true;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, false, stamp)) continue;
                return true;
            }
            final HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("project.name", config.getExecutionName() + "/CoS");
            String proppath = config.getProperties().get("exec.workingdir");
            if (proppath != null) {
                params.put("work.dir", FileUtil.normalizeFile((File)new File(proppath)));
            } else {
                params.put("work.dir", config.getExecutionDirectory());
            }
            if (RUN_MAIN.equals(actionName) || DEBUG_MAIN.equals(actionName) || PROFILE_MAIN.equals(actionName)) {
                FileObject selected = config.getSelectedFileObject();
                ClassPath srcs = ((ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectSourcesClassPath("classpath/source");
                String path = srcs.getResourceName(selected);
                if (path == null) {
                    return true;
                }
                params.put("execute.file", selected);
            } else {
                params.put("execute.classpath", this.createRuntimeClassPath(config.getMavenProject(), false));
            }
            String exargs = config.getProperties().get("exec.args");
            if (exargs != null) {
                String[] args = RunJarPanel.splitAll(exargs);
                if (params.get("execute.file") == null) {
                    params.put("classname", args[1]);
                }
                String[] appargs = args[2].split(" ");
                params.put("application.args", Arrays.asList(appargs));
                try {
                    params.put("run.jvmargs", CosChecker.extractDebugJVMOptions(args[0]));
                }
                catch (CommandLineException cli) {
                    LOG.log(Level.INFO, "error parsing exec.args property:" + args[0], cli);
                    if (DEBUG_MAIN.equals(actionName) || "debug".equals(actionName)) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error parsing exec.args property, arguments will not be passed to internal execution. Error: " + cli.getLocalizedMessage()), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.INFO, "error extracting debug params from exec.args property:" + args[0], ex);
                }
            }
            params.put("platform", ((ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform());
            params.put("maven.disableSources", Boolean.TRUE);
            if ((params.get("execute.file") != null || params.get("classname") != null) && (supported = JavaRunner.isSupported((String)(action2Quick = this.action2Quick(actionName)), params))) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (SwingUtilities.isEventDispatchThread()) {
                                        RP.post((Runnable)this);
                                        return;
                                    }
                                    try {
                                        CosChecker.this.collectStartupArgs(config, params);
                                        ExecutorTask tsk = JavaRunner.execute((String)action2Quick, (Map)params);
                                        CosChecker.this.warnCoSInOutput(tsk, config);
                                        tsk.addTaskListener(new TaskListener(){

                                            public void taskFinished(Task task) {
                                                CosChecker.warnTestCoS(config);
                                            }
                                        });
                                    }
                                    catch (IOException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    catch (UnsupportedOperationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                    finally {
                                        if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                                            CosChecker.touchCoSTimeStamp(config, false);
                                        }
                                    }
                                }
                            }, (String)config.getTaskDisplayName());
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRunTest(final RunConfig config) {
        String actionName = config.getActionName();
        if (!("test.single".equals(actionName) || "debug.test.single".equals(actionName) || "profile.test.single".equals(actionName))) {
            return true;
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(config)) {
            String argLine;
            String testng = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test", "testNGArtifactName");
            if (testng == null) {
                testng = "org.testng:testng";
            }
            List deps = config.getMavenProject().getTestDependencies();
            boolean haveJUnit = false;
            boolean haveTestNG = false;
            String testngVersion = null;
            for (Dependency d : deps) {
                if (d.getManagementKey().startsWith(testng)) {
                    testngVersion = d.getVersion();
                    haveTestNG = true;
                    continue;
                }
                if (!d.getManagementKey().startsWith("junit:junit")) continue;
                haveJUnit = true;
            }
            if (haveJUnit && haveTestNG && new ComparableVersion("6.5.1").compareTo(new ComparableVersion(testngVersion)) >= 0) {
                return true;
            }
            final HashMap<String, Object> params = new HashMap<String, Object>();
            String test = config.getProperties().get("test");
            if (test == null) {
                return true;
            }
            long stamp = CosChecker.getLastCoSLastTouch(config, true);
            if (this.checkImportantFiles(stamp, config)) {
                return true;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, true, stamp)) continue;
                return true;
            }
            FileObject selected = config.getSelectedFileObject();
            ProjectSourcesClassPathProvider cpp = (ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class);
            ClassPath srcs = cpp.getProjectSourcesClassPath("classpath/source");
            ClassPath[] cps = cpp.getProjectClassPaths("classpath/source");
            ClassPath testcp = ClassPathSupport.createProxyClassPath((ClassPath[])cps);
            if (selected != null) {
                String path = srcs.getResourceName(selected);
                if (path != null) {
                    String nameExt = selected.getNameExt().replace(".java", "Test.java");
                    FileObject testFo = testcp.findResource(path = path.replace(selected.getNameExt(), nameExt));
                    if (testFo == null) return true;
                    selected = testFo;
                } else {
                    path = testcp.getResourceName(selected);
                    if (path == null) {
                        return true;
                    }
                }
            } else {
                selected = testcp.findResource(test = test + ".java");
                if (selected == null) {
                    List<FileObject> mainSourceRoots = Arrays.asList(srcs.getRoots());
                    block12: for (FileObject root : testcp.getRoots()) {
                        if (mainSourceRoots.contains(root)) continue;
                        Enumeration enumeration = root.getData(true);
                        while (enumeration.hasMoreElements()) {
                            FileObject fo = (FileObject)enumeration.nextElement();
                            if (!fo.getNameExt().equals(test)) continue;
                            selected = fo;
                            break block12;
                        }
                    }
                }
            }
            if (selected == null) {
                return true;
            }
            params.put("execute.file", selected);
            params.put("platform", ((ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform());
            ArrayList<String> jvmProps = new ArrayList<String>();
            HashSet<String> jvmPropNames = new HashSet<String>();
            params.put("project.name", config.getExecutionName() + "/CoS");
            String dir = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "basedir", "test", "basedir");
            jvmPropNames.add("basedir");
            if (dir != null) {
                params.put("work.dir", dir);
                jvmProps.add("-Dbasedir=\"" + dir + "\"");
            } else {
                params.put("work.dir", config.getExecutionDirectory());
                jvmProps.add("-Dbasedir=\"" + config.getExecutionDirectory().getAbsolutePath() + "\"");
            }
            Properties sysProps = PluginPropertyUtils.getPluginPropertyParameter(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "systemProperties", "test");
            if (sysProps != null) {
                for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
                    jvmProps.add("-D" + entry.getKey() + "=" + entry.getValue());
                    jvmPropNames.add((String)entry.getKey());
                }
            }
            if (config.getProperties() != null) {
                for (Map.Entry<Object, Object> entry : config.getProperties().entrySet()) {
                    if ("maven.surefire.debug".equals(entry.getKey()) || "jpda.listen".equals(entry.getKey()) || "jpda.stopclass".equals(entry.getKey())) continue;
                    if ("nb.single.run.methodName".equals(entry.getKey())) {
                        params.put("methodname", entry.getValue());
                        actionName = "test.single".equals(actionName) ? "run.single.method" : "debug.single.method";
                        continue;
                    }
                    if (jvmPropNames.contains((String)entry.getKey())) continue;
                    jvmProps.add("-D" + entry.getKey() + "=" + entry.getValue());
                    jvmPropNames.add((String)entry.getKey());
                }
            }
            if ((argLine = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "argLine", "test", "argLine")) != null) {
                try {
                    String[] stringArray = CommandLineUtils.translateCommandline((String)argLine);
                    jvmProps.addAll(Arrays.asList(stringArray));
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            } else {
                argLine = config.getProperties().get("argLine");
                if (argLine != null) {
                    try {
                        jvmProps.addAll(CosChecker.extractDebugJVMOptions(argLine));
                    }
                    catch (CommandLineException commandLineException) {
                        LOG.log(Level.INFO, "error parsing argLine property:" + argLine, commandLineException);
                        if ("debug.test.single".equals(actionName)) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error parsing argLine property, arguments will not be passed to internal execution. Error: " + commandLineException.getLocalizedMessage()), 0);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.INFO, "error extracting debug params from argLine property:" + argLine, exception);
                    }
                }
            }
            String[] stringArray = PluginPropertyUtils.getPluginPropertyList(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "additionalClasspathElements", "additionalClasspathElement", "test");
            ClassPath cp = this.createRuntimeClassPath(config.getMavenProject(), true);
            if (stringArray != null) {
                ArrayList<URL> roots = new ArrayList<URL>();
                File base = FileUtil.toFile((FileObject)config.getProject().getProjectDirectory());
                for (String add : stringArray) {
                    File root = FileUtilities.resolveFilePath(base, add);
                    if (root != null) {
                        try {
                            URL url = Utilities.toURI((File)root).toURL();
                            if (FileUtil.isArchiveFile((URL)url)) {
                                url = FileUtil.getArchiveRoot((URL)url);
                            }
                            roots.add(url);
                        }
                        catch (MalformedURLException ex) {
                            Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Cannot convert ''{0}'' to URL", add);
                        }
                        continue;
                    }
                    Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Cannot convert ''{0}'' to URL.", add);
                }
                ClassPath addCp = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
                cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, addCp});
            }
            params.put("execute.classpath", cp);
            params.put("run.jvmargs", jvmProps);
            params.put("maven.disableSources", Boolean.TRUE);
            final String action2Quick = this.action2Quick(actionName);
            boolean supported = JavaRunner.isSupported((String)action2Quick, params);
            if (!supported) return true;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (SwingUtilities.isEventDispatchThread()) {
                                    RP.post((Runnable)this);
                                    return;
                                }
                                try {
                                    CosChecker.this.collectStartupArgs(config, params);
                                    ExecutorTask tsk = JavaRunner.execute((String)action2Quick, (Map)params);
                                    CosChecker.this.warnCoSInOutput(tsk, config);
                                    tsk.addTaskListener(new TaskListener(){

                                        public void taskFinished(Task task) {
                                            CosChecker.warnTestCoS(config);
                                        }
                                    });
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (UnsupportedOperationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                finally {
                                    CosChecker.touchCoSTimeStamp(config, true);
                                    if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                                        CosChecker.touchCoSTimeStamp(config, false);
                                    } else {
                                        CosChecker.deleteCoSTimeStamp(config, false);
                                    }
                                }
                            }
                        }, (String)config.getTaskDisplayName());
                    }
                });
                return false;
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return false;
        }
        CosChecker.warnNoTestCoS(config);
        return true;
    }

    private static void cleanGeneratedClassfiles(Project p) throws IOException {
        ArrayList<ClassPath> executePaths = new ArrayList<ClassPath>();
        for (SourceGroup g : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
            FileObject root = g.getRootFolder();
            ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/execute");
            if (cp == null) continue;
            executePaths.add(cp);
        }
        int res = JavaRunner.execute((String)"clean", Collections.singletonMap("execute.classpath", ClassPathSupport.createProxyClassPath((ClassPath[])executePaths.toArray(new ClassPath[0])))).result();
        if (res != 0) {
            throw new IOException("Failed to clean NetBeans-generated classes");
        }
    }

    private boolean checkImportantFiles(long stamp, RunConfig rc) {
        String name;
        M2Configuration m2c;
        assert (rc.getProject() != null);
        FileObject prjDir = rc.getProject().getProjectDirectory();
        if (this.isNewer(stamp, prjDir.getFileObject("pom.xml"))) {
            return true;
        }
        if (this.isNewer(stamp, prjDir.getFileObject("nbactions.xml"))) {
            return true;
        }
        M2ConfigProvider prov = (M2ConfigProvider)rc.getProject().getLookup().lookup(M2ConfigProvider.class);
        return prov != null && (m2c = prov.getActiveConfiguration()) != null && this.isNewer(stamp, prjDir.getFileObject(name = M2Configuration.getFileNameExt(m2c.getId())));
    }

    private boolean isNewer(long stamp, FileObject fo) {
        File fl;
        return fo != null && (fl = FileUtil.toFile((FileObject)fo)).lastModified() >= stamp;
    }

    private ClassPath createRuntimeClassPath(MavenProject prj, boolean test) {
        List<URI> roots = test ? TestRuntimeClassPathImpl.createPath(prj) : RuntimeClassPathImpl.createPath(prj);
        return ClassPathSupport.createClassPath(AbstractProjectClassPathImpl.getPath(roots.toArray(new URI[0]), null));
    }

    private static File getCoSFile(RunConfig rc, boolean test) {
        if (rc.getProject() == null) {
            return null;
        }
        return CosChecker.getCoSFile(rc.getMavenProject(), test);
    }

    private static File getCoSFile(MavenProject mp, boolean test) {
        String path;
        if (mp == null) {
            return null;
        }
        Build build = mp.getBuild();
        if (build == null) {
            return null;
        }
        String string = path = test ? build.getTestOutputDirectory() : build.getOutputDirectory();
        if (path == null) {
            return null;
        }
        File fl = new File(path);
        fl = FileUtil.normalizeFile((File)fl);
        return new File(fl, NB_COS);
    }

    private static long getLastCoSLastTouch(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl == null) {
            return 0L;
        }
        if (fl.getParentFile() == null || !fl.getParentFile().exists()) {
            return 0L;
        }
        if (!fl.exists()) {
            return Long.MAX_VALUE;
        }
        return fl.lastModified();
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, boolean test) {
        return CosChecker.touchCoSTimeStamp(rc, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(RunConfig rc, boolean test, long stamp) {
        if (rc.getProject() == null) {
            return false;
        }
        return CosChecker.touchCoSTimeStamp(rc.getMavenProject(), test, stamp);
    }

    private static boolean touchCoSTimeStamp(MavenProject mvn, boolean test) {
        return CosChecker.touchCoSTimeStamp(mvn, test, System.currentTimeMillis());
    }

    private static boolean touchCoSTimeStamp(MavenProject mvn, boolean test, long stamp) {
        boolean folderCreated;
        File fl = CosChecker.getCoSFile(mvn, test);
        if (fl == null) {
            return false;
        }
        if (!(fl.getParentFile() != null && fl.getParentFile().exists() || (folderCreated = fl.getParentFile().mkdir()))) {
            return false;
        }
        if (!fl.exists()) {
            try {
                return fl.createNewFile();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return fl.setLastModified(stamp);
    }

    private static void deleteCoSTimeStamp(RunConfig rc, boolean test) {
        File fl = CosChecker.getCoSFile(rc, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    private static void deleteCoSTimeStamp(MavenProject mp, boolean test) {
        File fl = CosChecker.getCoSFile(mp, test);
        if (fl != null && fl.exists()) {
            fl.delete();
        }
    }

    static List<String> extractDebugJVMOptions(String argLine) throws Exception {
        String[] split = CommandLineUtils.translateCommandline((String)argLine);
        ArrayList<String> toRet = new ArrayList<String>();
        for (String arg : split) {
            if ("-Xdebug".equals(arg) || "-Djava.compiler=none".equals(arg) || "-Xnoagent".equals(arg) || arg.startsWith("-Xrunjdwp") || arg.trim().length() == 0) continue;
            toRet.add(arg);
        }
        return toRet;
    }

    private String action2Quick(String actionName) {
        if ("clean".equals(actionName)) {
            return "clean";
        }
        if ("run".equals(actionName) || RUN_MAIN.equals(actionName)) {
            return "run";
        }
        if ("debug".equals(actionName) || DEBUG_MAIN.equals(actionName)) {
            return "debug";
        }
        if ("profile".equals(actionName) || PROFILE_MAIN.equals(actionName)) {
            return "profile";
        }
        if ("test".equals(actionName) || "test.single".equals(actionName) || "run.single.method".equals(actionName)) {
            return "junit";
        }
        if ("debug.test.single".equals(actionName) || "debug.single.method".equals(actionName)) {
            return "junit-debug";
        }
        if ("profile.test.single".equals(actionName)) {
            return "junit-profile";
        }
        assert (false) : "Cannot convert " + actionName + " to quick actions.";
        return null;
    }

    private void collectStartupArgs(RunConfig config, Map<String, Object> params) {
        StartupExtender.StartMode mode;
        String actionName = config.getActionName();
        if ("run".equals(actionName) || RUN_MAIN.equals(actionName)) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if ("debug".equals(actionName) || DEBUG_MAIN.equals(actionName)) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if ("profile".equals(actionName) || "profile.single".equals(actionName) || PROFILE_MAIN.equals(actionName)) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if ("profile.test.single".equals(actionName)) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return;
        }
        InstanceContent ic = new InstanceContent();
        Project p = config.getProject();
        if (p != null) {
            ic.add((Object)p);
            ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
            if (pp != null) {
                ic.add((Object)pp.getJavaPlatform());
            }
        }
        HashSet args = new HashSet();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        if (!args.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                sb.append(arg).append(' ');
            }
            params.put(STARTUP_ARGS_KEY, sb.toString());
        }
    }

    static void touchProject(Project project) {
        NbMavenProject prj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (prj != null) {
            MavenProject mvn = prj.getMavenProject();
            if (RunUtils.hasApplicationCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mvn, false);
            } else {
                boolean doClean;
                File f = CosChecker.getCoSFile(mvn, false);
                boolean bl = doClean = f != null && f.exists();
                if (doClean) {
                    try {
                        CosChecker.cleanGeneratedClassfiles(project);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "Error cleaning up", ex);
                    }
                }
                CosChecker.deleteCoSTimeStamp(mvn, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(project)) {
                CosChecker.touchCoSTimeStamp(mvn, true);
            } else {
                CosChecker.deleteCoSTimeStamp(mvn, true);
            }
        }
    }

    private static void warnNoTestCoS(RunConfig config) {
        if (warnedNoCoS) {
            return;
        }
        final Project project = config.getProject();
        if (project == null) {
            return;
        }
        final Notification n = NotificationDisplayer.getDefault().notify(Bundle.CosChecker_no_test_cos_title(), (Icon)ImageUtilities.loadImageIcon((String)SUGGESTION, (boolean)true), Bundle.CosChecker_no_test_cos_details(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CosChecker.showCompilePanel(project);
            }
        }, NotificationDisplayer.Priority.LOW);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                n.clear();
            }
        }, 15000);
        warnedNoCoS = true;
    }

    private static void warnTestCoS(RunConfig config) {
        if (warnedCoS) {
            return;
        }
        final Project project = config.getProject();
        if (project == null) {
            return;
        }
        final Notification n = NotificationDisplayer.getDefault().notify(Bundle.CosChecker_test_cos_title(), (Icon)ImageUtilities.loadImageIcon((String)SUGGESTION, (boolean)true), Bundle.CosChecker_test_cos_details(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CosChecker.showCompilePanel(project);
            }
        }, NotificationDisplayer.Priority.LOW);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                n.clear();
            }
        }, 15000);
        warnedCoS = true;
    }

    private static void showCompilePanel(Project project) {
        CustomizerProviderImpl prv = (CustomizerProviderImpl)project.getLookup().lookup(CustomizerProviderImpl.class);
        if (prv != null) {
            prv.showCustomizer("COMPILE");
        }
    }

    private void warnCoSInOutput(ExecutorTask tsk, RunConfig config) throws IOException {
    }

    public static class COSExChecker
    implements ExecutionResultChecker {
        @Override
        public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                CosChecker.touchCoSTimeStamp(config, false);
            } else {
                CosChecker.deleteCoSTimeStamp(config, false);
            }
            if (RunUtils.hasTestCompileOnSaveEnabled(config)) {
                CosChecker.touchCoSTimeStamp(config, true);
            } else {
                CosChecker.deleteCoSTimeStamp(config, true);
            }
        }
    }

    public static class CosPOH
    extends ProjectOpenedHook {
        private final Project project;
        private final PropertyChangeListener listener;

        public CosPOH(Project prj) {
            this.project = prj;
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        CosChecker.touchProject(CosPOH.this.project);
                    }
                }
            };
        }

        protected void projectOpened() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CosChecker.touchProject(CosPOH.this.project);
                }
            });
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (prj != null) {
                prj.addPropertyChangeListener(this.listener);
            }
        }

        protected void projectClosed() {
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (prj != null) {
                prj.removePropertyChangeListener(this.listener);
                final MavenProject mvn = prj.getMavenProject();
                RP.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            CosChecker.cleanGeneratedClassfiles(CosPOH.this.project);
                        }
                        catch (IOException ex) {
                            LOG.log(Level.FINE, "Error cleaning up", ex);
                        }
                        finally {
                            CosChecker.deleteCoSTimeStamp(mvn, true);
                            CosChecker.deleteCoSTimeStamp(mvn, false);
                        }
                    }
                });
            }
        }
    }
}

